/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.sequences;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jebl.evolution.sequences.AminoAcidState;
import jebl.evolution.sequences.State;
import jebl.evolution.sequences.StateClassification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AminoAcids {
    public static final String NAME = "amino acid";
    public static final int CANONICAL_STATE_COUNT = 22;
    public static final int STATE_COUNT = 29;
    public static final AminoAcidState A_STATE = new AminoAcidState("Alanine", "Ala", "A", 0);
    public static final AminoAcidState C_STATE = new AminoAcidState("Cysteine", "Cys", "C", 1);
    public static final AminoAcidState D_STATE = new AminoAcidState("Aspartic acid", "Asp", "D", 2);
    public static final AminoAcidState E_STATE = new AminoAcidState("Glutamic acid", "Glu", "E", 3);
    public static final AminoAcidState F_STATE = new AminoAcidState("Phenylalanine", "Phe", "F", 4);
    public static final AminoAcidState G_STATE = new AminoAcidState("Glycine", "Gly", "G", 5);
    public static final AminoAcidState H_STATE = new AminoAcidState("Histidine", "His", "H", 6);
    public static final AminoAcidState I_STATE = new AminoAcidState("Isoleucine", "Ile", "I", 7);
    public static final AminoAcidState K_STATE = new AminoAcidState("Lysine", "Lys", "K", 8);
    public static final AminoAcidState L_STATE = new AminoAcidState("Leucine", "Leu", "L", 9);
    public static final AminoAcidState M_STATE = new AminoAcidState("Methionine", "Met", "M", 10);
    public static final AminoAcidState N_STATE = new AminoAcidState("Asparagine", "Asn", "N", 11);
    public static final AminoAcidState P_STATE = new AminoAcidState("Proline", "Pro", "P", 12);
    public static final AminoAcidState Q_STATE = new AminoAcidState("Glutamine", "Gln", "Q", 13);
    public static final AminoAcidState R_STATE = new AminoAcidState("Arginine", "Arg", "R", 14);
    public static final AminoAcidState S_STATE = new AminoAcidState("Serine", "Ser", "S", 15);
    public static final AminoAcidState T_STATE = new AminoAcidState("Threonine", "Thr", "T", 16);
    public static final AminoAcidState V_STATE = new AminoAcidState("Valine", "Val", "V", 17);
    public static final AminoAcidState W_STATE = new AminoAcidState("Tryptophan", "Trp", "W", 18);
    public static final AminoAcidState Y_STATE = new AminoAcidState("Tyrosine", "Tyr", "Y", 19);
    public static final AminoAcidState U_STATE = new AminoAcidState("Selenocysteine", "Sec", "U", 20);
    public static final AminoAcidState O_STATE = new AminoAcidState("Pyrrolysine", "Pyl", "O", 21);
    @Deprecated
    public static final AminoAcidState[] CANONICAL_STATES = new AminoAcidState[]{A_STATE, C_STATE, D_STATE, E_STATE, F_STATE, G_STATE, H_STATE, I_STATE, K_STATE, L_STATE, M_STATE, N_STATE, P_STATE, Q_STATE, R_STATE, S_STATE, T_STATE, V_STATE, W_STATE, Y_STATE, U_STATE, O_STATE};
    public static final AminoAcidState B_STATE = new AminoAcidState("Asparagine or aspartic acid", "Asx", "B", 22, new AminoAcidState[]{D_STATE, N_STATE});
    public static final AminoAcidState Z_STATE = new AminoAcidState("Glutamine or glutamic acid", "Glx", "Z", 23, new AminoAcidState[]{E_STATE, Q_STATE});
    public static final AminoAcidState J_STATE = new AminoAcidState("Leucine or Isoleucine", "Xle", "J", 24, new AminoAcidState[]{I_STATE, L_STATE});
    public static final AminoAcidState X_STATE = new AminoAcidState("Unknown amino acid", "Xaa", "X", 25, CANONICAL_STATES);
    public static final AminoAcidState UNKNOWN_STATE = new AminoAcidState("Unknown amino acid", "Xaa", "?", 26, CANONICAL_STATES);
    public static final AminoAcidState STOP_STATE = new AminoAcidState("Stop codon", " * ", "*", 27);
    public static final AminoAcidState GAP_STATE = new AminoAcidState("Gap", " - ", "-", 28, CANONICAL_STATES);
    @Deprecated
    public static final AminoAcidState[] STATES = new AminoAcidState[]{A_STATE, C_STATE, D_STATE, E_STATE, F_STATE, G_STATE, H_STATE, I_STATE, K_STATE, L_STATE, M_STATE, N_STATE, P_STATE, Q_STATE, R_STATE, S_STATE, T_STATE, V_STATE, W_STATE, Y_STATE, U_STATE, O_STATE, B_STATE, Z_STATE, J_STATE, X_STATE, UNKNOWN_STATE, STOP_STATE, GAP_STATE};
    public static final StateClassification CHEMICAL_CLASSIFICATION = new StateClassification.Default("chemical", new String[]{"alphatic", "phenylalanine", "sulphur", "glycine", "hydroxyl", "tryptophan", "tyrosine", "proline", "acidic", "amide", "basic"}, new State[][]{{A_STATE, V_STATE, I_STATE, L_STATE}, {F_STATE}, {C_STATE, M_STATE}, {G_STATE}, {S_STATE, T_STATE}, {W_STATE}, {Y_STATE}, {P_STATE}, {D_STATE, E_STATE}, {N_STATE, Q_STATE}, {H_STATE, K_STATE, R_STATE}});
    public static final StateClassification HYDROPATHY_CLASSIFICATION = new StateClassification.Default("hydropathy", new String[]{"hydropathic", "neutral", "hydrophilic"}, new State[][]{{I_STATE, V_STATE, L_STATE, F_STATE, C_STATE, M_STATE, A_STATE, W_STATE}, {G_STATE, T_STATE, S_STATE, Y_STATE, P_STATE, H_STATE}, {D_STATE, E_STATE, K_STATE, N_STATE, Q_STATE, R_STATE}});
    public static final StateClassification VOLUME_CLASSIFICATION = new StateClassification.Default("volume", new String[]{"60-90", "108-117", "138-154", "162-174", "189-228"}, new State[][]{{G_STATE, A_STATE, S_STATE}, {C_STATE, D_STATE, P_STATE, N_STATE, T_STATE}, {E_STATE, V_STATE, Q_STATE, H_STATE}, {M_STATE, I_STATE, L_STATE, K_STATE, R_STATE}, {F_STATE, Y_STATE, W_STATE}});
    private static final String[] AMINOACID_TRIPLETS = new String[]{"Ala", "Cys", "Asp", "Glu", "Phe", "Gly", "His", "Ile", "Lys", "Leu", "Met", "Asn", "Pro", "Gln", "Arg", "Ser", "Thr", "Val", "Trp", "Tyr", "Sec", "Pyl", "Asx", "Glx", "Xle", " X ", " * ", " ? ", " - "};
    private static final int STATE_BY_CODE_SIZE = 128;
    private static final AminoAcidState[] statesByCode = new AminoAcidState[128];

    private AminoAcids() {
    }

    public static int getStateCount() {
        return 29;
    }

    public static List<AminoAcidState> getStates() {
        return Collections.unmodifiableList(Arrays.asList(STATES));
    }

    public static int getCanonicalStateCount() {
        return 22;
    }

    public static List<State> getCanonicalStates() {
        return Collections.unmodifiableList(Arrays.asList((State[])CANONICAL_STATES));
    }

    public static AminoAcidState getState(char code) {
        if (code < '\u0000' || code >= '\u0080') {
            return null;
        }
        return statesByCode[code];
    }

    public static AminoAcidState getState(String code) {
        return AminoAcids.getState(code.charAt(0));
    }

    public static AminoAcidState getState(int index) {
        return STATES[index];
    }

    public static AminoAcidState getUnknownState() {
        return UNKNOWN_STATE;
    }

    public static AminoAcidState getGapState() {
        return GAP_STATE;
    }

    public static boolean isUnknown(AminoAcidState state) {
        return state == UNKNOWN_STATE;
    }

    public static boolean isGap(AminoAcidState state) {
        return state == GAP_STATE;
    }

    public static String getTripletCode(AminoAcidState state) {
        return AMINOACID_TRIPLETS[state.getIndex()];
    }

    public static AminoAcidState[] toStateArray(String sequenceString) {
        AminoAcidState[] seq = new AminoAcidState[sequenceString.length()];
        for (int i = 0; i < seq.length; ++i) {
            seq[i] = AminoAcids.getState(sequenceString.charAt(i));
        }
        return seq;
    }

    public static AminoAcidState[] toStateArray(byte[] indexArray) {
        AminoAcidState[] seq = new AminoAcidState[indexArray.length];
        for (int i = 0; i < seq.length; ++i) {
            seq[i] = AminoAcids.getState(indexArray[i]);
        }
        return seq;
    }

    static {
        for (int i = 0; i < statesByCode.length; ++i) {
            AminoAcids.statesByCode[i] = null;
        }
        for (AminoAcidState state : STATES) {
            char code = state.getCode().charAt(0);
            AminoAcids.statesByCode[code] = state;
            AminoAcids.statesByCode[Character.toLowerCase((char)code)] = state;
        }
    }
}

