/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.tree.TreeParameterModel;
import dr.inference.model.Parameter;

public class TrialTreeParameterModel
extends TreeParameterModel {
    private boolean includeTips = true;

    public TrialTreeParameterModel(MutableTreeModel mutableTreeModel, Parameter parameter, boolean bl, boolean bl2, TreeTrait.Intent intent) {
        super(mutableTreeModel, parameter, bl, intent);
        this.includeTips = bl2;
    }

    @Override
    public int getParameterSize() {
        int n = super.getParameterSize();
        if (!this.includeTips) {
            n -= this.tree.getExternalNodeCount();
        }
        return n;
    }

    @Override
    public int getNodeNumberFromParameterIndex(int n) {
        int n2 = super.getNodeNumberFromParameterIndex(n);
        if (!this.includeTips) {
            n2 += this.tree.getExternalNodeCount();
        }
        return n2;
    }

    @Override
    public int getParameterIndexFromNodeNumber(int n) {
        int n2 = super.getParameterIndexFromNodeNumber(n);
        if (!this.includeTips) {
            n2 -= this.tree.getExternalNodeCount();
        }
        return n2;
    }

    @Override
    public double getNodeValue(Tree tree, NodeRef nodeRef) {
        assert (!tree.isExternal(nodeRef) && !this.includeTips) : "tip nodes do not have parameter values!";
        return super.getNodeValue(tree, nodeRef);
    }

    @Override
    public void setNodeValue(Tree tree, NodeRef nodeRef, double d) {
        assert (!tree.isExternal(nodeRef) && !this.includeTips) : "tip nodes do not have parameter values!";
        super.setNodeValue(tree, nodeRef, d);
    }
}

