/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tipstatesmodel;

import dr.evolution.alignment.PatternList;
import dr.evolution.tree.Tree;
import dr.evolution.util.TaxonList;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.HashMap;
import java.util.Map;

public abstract class TipStatesModel
extends AbstractModel {
    protected int[][] states;
    protected boolean[] excluded;
    protected int patternCount = 0;
    protected int stateCount;
    protected TaxonList includeTaxa;
    protected TaxonList excludeTaxa;
    protected Tree tree;
    private PatternList patternList = null;
    protected Map<Integer, String> taxonMap = new HashMap<Integer, String>();

    public TipStatesModel(String string, TaxonList taxonList, TaxonList taxonList2) {
        super(string);
        this.includeTaxa = taxonList;
        this.excludeTaxa = taxonList2;
    }

    public final void setTree(Tree tree) {
        int n;
        this.tree = tree;
        int n2 = tree.getExternalNodeCount();
        this.excluded = new boolean[n2];
        if (this.includeTaxa != null) {
            for (n = 0; n < n2; ++n) {
                if (this.includeTaxa.getTaxonIndex(tree.getNodeTaxon(tree.getExternalNode(n))) != -1) continue;
                this.excluded[n] = true;
            }
        }
        if (this.excludeTaxa != null) {
            for (n = 0; n < n2; ++n) {
                if (this.excludeTaxa.getTaxonIndex(tree.getNodeTaxon(tree.getExternalNode(n))) == -1) continue;
                this.excluded[n] = true;
            }
        }
        this.states = new int[n2][];
        this.taxaChanged();
    }

    protected abstract void taxaChanged();

    public final void setStates(PatternList patternList, int n, int n2, String string) {
        if (this.patternList == null) {
            this.patternList = patternList;
            this.patternCount = patternList.getPatternCount();
            this.stateCount = patternList.getDataType().getStateCount();
        } else if (patternList != this.patternList) {
            throw new RuntimeException("The TipStatesModel with id, " + this.getId() + ", has already been associated with a patternList.");
        }
        if (this.states[n2] == null) {
            this.states[n2] = new int[this.patternCount];
        }
        for (int i = 0; i < this.patternCount; ++i) {
            this.states[n2][i] = patternList.getPatternState(n, i);
        }
        this.taxonMap.put(n2, string);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    public PatternList getPatternList() {
        return this.patternList;
    }

    public abstract Type getModelType();

    public abstract void getTipPartials(int var1, double[] var2);

    public abstract void getTipStates(int var1, int[] var2);

    public static enum Type {
        PARTIALS,
        STATES;

    }
}

