/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.operators.AbstractTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.math.MathUtils;

public class WilsonBalding
extends AbstractTreeOperator {
    private TreeModel tree = null;
    private final int tipCount;

    public WilsonBalding(TreeModel treeModel, double d) {
        this.tree = treeModel;
        this.tipCount = treeModel.getExternalNodeCount();
        this.setWeight(d);
    }

    @Override
    public double doOperation() {
        double d = this.proposeTree();
        if (this.tree.getExternalNodeCount() != this.tipCount) {
            int n = this.tree.getExternalNodeCount();
            throw new RuntimeException("Lost some tips in modified SPR! (" + this.tipCount + "-> " + n + ")");
        }
        return d;
    }

    public double proposeTree() {
        NodeRef nodeRef;
        int n = this.tree.getNodeCount();
        do {
            nodeRef = this.tree.getNode(MathUtils.nextInt(n));
        } while (this.tree.getRoot() == nodeRef);
        NodeRef nodeRef2 = this.tree.getParent(nodeRef);
        NodeRef nodeRef3 = this.tree.getNode(MathUtils.nextInt(n));
        NodeRef nodeRef4 = this.tree.getParent(nodeRef3);
        while (nodeRef4 != null && this.tree.getNodeHeight(nodeRef4) <= this.tree.getNodeHeight(nodeRef) || nodeRef == nodeRef3) {
            nodeRef3 = this.tree.getNode(MathUtils.nextInt(n));
            nodeRef4 = this.tree.getParent(nodeRef3);
        }
        if (nodeRef3 == this.tree.getRoot() || nodeRef2 == this.tree.getRoot()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (nodeRef4 == nodeRef2 || nodeRef3 == nodeRef2 || nodeRef4 == nodeRef) {
            return Double.NEGATIVE_INFINITY;
        }
        NodeRef nodeRef5 = this.getOtherChild(this.tree, nodeRef2, nodeRef);
        NodeRef nodeRef6 = this.tree.getParent(nodeRef2);
        double d = Math.max(this.tree.getNodeHeight(nodeRef), this.tree.getNodeHeight(nodeRef3));
        double d2 = this.tree.getNodeHeight(nodeRef4) - d;
        double d3 = d + MathUtils.nextDouble() * d2;
        double d4 = Math.max(this.tree.getNodeHeight(nodeRef), this.tree.getNodeHeight(nodeRef5));
        double d5 = this.tree.getNodeHeight(nodeRef6) - d4;
        double d6 = d2 / Math.abs(d5);
        this.tree.beginTreeEdit();
        if (nodeRef3 == this.tree.getRoot()) {
            this.tree.removeChild(nodeRef2, nodeRef5);
            this.tree.removeChild(nodeRef6, nodeRef2);
            this.tree.addChild(nodeRef2, nodeRef3);
            this.tree.addChild(nodeRef6, nodeRef5);
            this.tree.setRoot(nodeRef2);
        } else if (nodeRef2 == this.tree.getRoot()) {
            this.tree.removeChild(nodeRef4, nodeRef3);
            this.tree.removeChild(nodeRef2, nodeRef5);
            this.tree.addChild(nodeRef2, nodeRef3);
            this.tree.addChild(nodeRef4, nodeRef2);
            this.tree.setRoot(nodeRef5);
        } else {
            this.tree.removeChild(nodeRef4, nodeRef3);
            this.tree.removeChild(nodeRef2, nodeRef5);
            this.tree.removeChild(nodeRef6, nodeRef2);
            this.tree.addChild(nodeRef2, nodeRef3);
            this.tree.addChild(nodeRef4, nodeRef2);
            this.tree.addChild(nodeRef6, nodeRef5);
        }
        this.tree.setNodeHeight(nodeRef2, d3);
        this.tree.endTreeEdit();
        return Math.log(d6);
    }

    public double getMinimumAcceptanceLevel() {
        return 0.01;
    }

    public String getPerformanceSuggestion() {
        return "";
    }

    @Override
    public String getOperatorName() {
        return "wilsonBalding(" + this.tree.getId() + ")";
    }
}

