/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;

public abstract class ODEDemographicFunction
extends DemographicFunction.Abstract {
    protected int nvar = 0;
    protected int kmax = 200;
    protected int kinc = 200;
    protected int kabsolutemax = 200000;
    protected int klast = -1;
    protected double hinit = 0.1;
    protected double[][] Y;
    protected double[] T;
    protected boolean RKwarning;
    protected double[] Ynow;
    protected double Tnow;
    static final double a2 = 0.2;
    static final double a3 = 0.3;
    static final double a4 = 0.6;
    static final double a5 = 1.0;
    static final double a6 = 0.875;
    static final double b21 = 0.2;
    static final double b31 = 0.075;
    static final double b32 = 0.225;
    static final double b41 = 0.3;
    static final double b42 = -0.9;
    static final double b43 = 1.2;
    static final double b51 = -0.2037037037037037;
    static final double b52 = 2.5;
    static final double b53 = -2.5925925925925926;
    static final double b54 = 1.2962962962962963;
    static final double b61 = 0.029495804398148147;
    static final double b62 = 0.341796875;
    static final double b63 = 0.041594328703703706;
    static final double b64 = 0.40034541377314814;
    static final double b65 = 0.061767578125;
    static final double c1 = 0.09788359788359788;
    static final double c3 = 0.4025764895330113;
    static final double c4 = 0.21043771043771045;
    static final double c6 = 0.2891022021456804;
    static final double dc1 = -0.004293774801587311;
    static final double dc3 = 0.018668586093857853;
    static final double dc4 = -0.034155026830808066;
    static final double dc5 = -0.019321986607142856;
    static final double dc6 = 0.03910220214568039;
    private double[] ak2;
    private double[] ak3;
    private double[] ak4;
    private double[] ak5;
    private double[] ak6;
    static final double SAFETY = 0.9;
    static final double PGROW = -0.2;
    static final double PSHRNK = -0.25;
    static final double ERRCON = 1.89E-4;
    protected double hdid;
    protected double hnext;
    protected double[] Ytemp;
    protected double[] Yerr;
    protected int MAXSTP = 10000;
    protected double TINY = 1.0E-30;
    protected int nok = 0;
    protected int nbad = 0;
    protected double[] y;
    protected double[] dydt;
    protected double[] yscal;
    protected double dtsav = 0.1;
    protected double hmin = 1.0E-16;
    protected double eps = 1.0E-4;
    protected boolean RKfail = false;

    public ODEDemographicFunction(Units.Type type) {
        super(type);
    }

    @Override
    public double getNumericalIntegral(double d, double d2) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public double getDemographic(double d) {
        this.Evaluate(d);
        if (this.RKfail) {
            return 0.0;
        }
        return this.getDemographicFromPrevalence(this.Ynow, d);
    }

    @Override
    public double getIntensity(double d) {
        this.Evaluate(d);
        if (this.RKfail) {
            return Math.log(0.0);
        }
        return this.Ynow[0];
    }

    abstract void derivs(double var1, double[] var3, double[] var4);

    abstract void setInit();

    abstract double getDemographicFromPrevalence(double[] var1, double var2);

    void Evaluate(double d) {
        int n;
        if (this.RKfail) {
            return;
        }
        if (d < 0.0) {
            throw new RuntimeException("t cannot be negative");
        }
        if (this.klast == -1 || d > this.T[this.klast]) {
            if (this.klast + 1 >= this.kmax) {
                this.RKresize();
            }
            try {
                this.RungeKutta(d);
            }
            catch (RuntimeException runtimeException) {
                System.err.println(runtimeException.getMessage());
                this.RKfail = true;
                return;
            }
            for (int i = 0; i < this.nvar; ++i) {
                this.Ynow[i] = this.Y[i][this.klast];
            }
            this.Tnow = d;
            return;
        }
        if (d == this.T[this.klast]) {
            for (int i = 0; i < this.nvar; ++i) {
                this.Ynow[i] = this.Y[i][this.klast];
            }
            this.Tnow = d;
            return;
        }
        int n2 = (int)Math.floor(d / this.dtsav);
        if (n2 > this.klast - 1) {
            n2 = this.klast - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = n2 + 1) > this.klast || this.T[n2] > d) {
            while (n > this.klast || this.T[n2] > d) {
                --n2;
                --n;
            }
        } else if (n2 < 0 || this.T[n] <= d) {
            while (n2 < 0 || this.T[n] <= d) {
                ++n2;
                ++n;
            }
        }
        if (this.T[n2] == d) {
            for (int i = 0; i < this.nvar; ++i) {
                this.Ynow[i] = this.Y[i][n2];
            }
        } else {
            for (int i = 0; i < this.nvar; ++i) {
                this.Ynow[i] = this.Y[i][n2] + (d - this.T[n2]) * (this.Y[i][n] - this.Y[i][n2]) / (this.T[n] - this.T[n2]);
            }
        }
        this.Tnow = d;
    }

    void RKinit() {
        this.klast = -1;
        this.RKwarning = false;
        this.RKfail = false;
        if (this.Y == null || this.Y.length != this.nvar || this.Y[0].length != this.kmax) {
            this.Y = new double[this.nvar][this.kmax];
            this.T = new double[this.kmax];
            this.Ynow = new double[this.nvar];
            this.ak2 = new double[this.nvar];
            this.ak3 = new double[this.nvar];
            this.ak4 = new double[this.nvar];
            this.ak5 = new double[this.nvar];
            this.ak6 = new double[this.nvar];
            this.Ytemp = new double[this.nvar];
            this.Yerr = new double[this.nvar];
            this.y = new double[this.nvar];
            this.dydt = new double[this.nvar];
            this.yscal = new double[this.nvar];
        }
        this.nbad = 0;
        this.nok = 0;
    }

    void RKresize() {
        if (this.Y == null) {
            throw new RuntimeException("Y not yet allocated");
        }
        if (this.T == null) {
            throw new RuntimeException("T not yet allocated");
        }
        if (this.kmax == this.kabsolutemax) {
            throw new RuntimeException("kabsolutemax exceeded");
        }
        int n = this.kmax;
        this.kmax += this.kinc;
        double[][] dArray = this.Y;
        double[] dArray2 = this.T;
        this.Y = new double[this.nvar][this.kmax];
        this.T = new double[this.kmax];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.nvar; ++j) {
                this.Y[j][i] = dArray[j][i];
            }
            this.T[i] = dArray2[i];
        }
    }

    public boolean RKwarn() {
        return this.RKwarning;
    }

    void RungeKutta(double d) {
        int n;
        double d2;
        if (this.klast == this.kmax - 1) {
            throw new RuntimeException("storage space is exceeded");
        }
        if (this.klast == -1) {
            this.setInit();
            this.T[0] = 0.0;
            ++this.klast;
        }
        if (d == 0.0) {
            return;
        }
        double d3 = d2 = this.T[this.klast];
        double d4 = d2;
        for (n = 0; n < this.nvar; ++n) {
            this.y[n] = this.Y[n][this.klast];
        }
        double d5 = this.hinit;
        for (int i = 0; i < this.MAXSTP; ++i) {
            double d6 = i;
            if (i > this.MAXSTP / 2) {
                d6 += 3.0;
            }
            this.derivs(d3, this.y, this.dydt);
            for (n = 0; n < this.nvar; ++n) {
                this.yscal[n] = Math.abs(this.y[n]) + Math.abs(this.dydt[n] * d5) + this.TINY;
            }
            if (this.klast < this.kmax - 2 && Math.abs(d3 - d4) > Math.abs(this.dtsav)) {
                ++this.klast;
                for (n = 0; n < this.nvar; ++n) {
                    this.Y[n][this.klast] = this.y[n];
                }
                this.T[this.klast] = d3;
                d4 = d3;
            }
            if ((d3 + d5 - d) * (d3 + d5 - d2) > 0.0) {
                d5 = d - d3;
            }
            d3 = this.rkqs(this.y, this.dydt, d3, d5, this.yscal);
            if (this.hdid == d5) {
                ++this.nok;
            } else {
                ++this.nbad;
            }
            if ((d3 - d) * (d - d2) >= 0.0) {
                if (this.klast < this.kmax - 1) {
                    ++this.klast;
                    for (n = 0; n < this.nvar; ++n) {
                        this.Y[n][this.klast] = this.y[n];
                    }
                    this.T[this.klast] = d3;
                }
                return;
            }
            if (Math.abs(this.hnext) <= this.hmin) {
                throw new RuntimeException("Step size too small in odeint");
            }
            d5 = this.hnext;
        }
        throw new RuntimeException("Too many steps in routine odeint");
    }

    double rkqs(double[] dArray, double[] dArray2, double d, double d2, double[] dArray3) {
        int n;
        double d3;
        double d4;
        block4: {
            double d5;
            double d6;
            d4 = d2;
            do {
                this.rkck(dArray, dArray2, d, d4);
                d3 = 0.0;
                for (n = 0; n < this.nvar; ++n) {
                    d3 = Math.max(d3, Math.abs(this.Yerr[n] / dArray3[n]));
                }
                if ((d3 /= this.eps) <= 1.0) break block4;
                if (Double.isNaN(d3)) {
                    throw new RuntimeException("errmax NaN");
                }
                d5 = 0.9 * d4 * Math.pow(d3, -0.25);
            } while ((d6 = d + (d4 = d4 >= 0.0 ? Math.max(d5, 0.1 * d4) : Math.min(d5, 0.1 * d4))) != d);
            throw new RuntimeException("stepsize underflow in rkqs");
        }
        this.hnext = d3 > 1.89E-4 ? 0.9 * d4 * Math.pow(d3, -0.2) : 5.0 * d4;
        this.hdid = d4;
        d += this.hdid;
        for (n = 0; n < this.nvar; ++n) {
            dArray[n] = this.Ytemp[n];
        }
        return d;
    }

    void rkck(double[] dArray, double[] dArray2, double d, double d2) {
        int n;
        for (n = 0; n < this.nvar; ++n) {
            this.Ytemp[n] = dArray[n] + 0.2 * d2 * dArray2[n];
        }
        this.derivs(d + 0.2 * d2, this.Ytemp, this.ak2);
        for (n = 0; n < this.nvar; ++n) {
            this.Ytemp[n] = dArray[n] + d2 * (0.075 * dArray2[n] + 0.225 * this.ak2[n]);
        }
        this.derivs(d + 0.3 * d2, this.Ytemp, this.ak3);
        for (n = 0; n < this.nvar; ++n) {
            this.Ytemp[n] = dArray[n] + d2 * (0.3 * dArray2[n] + -0.9 * this.ak2[n] + 1.2 * this.ak3[n]);
        }
        this.derivs(d + 0.6 * d2, this.Ytemp, this.ak4);
        for (n = 0; n < this.nvar; ++n) {
            this.Ytemp[n] = dArray[n] + d2 * (-0.2037037037037037 * dArray2[n] + 2.5 * this.ak2[n] + -2.5925925925925926 * this.ak3[n] + 1.2962962962962963 * this.ak4[n]);
        }
        this.derivs(d + 1.0 * d2, this.Ytemp, this.ak5);
        for (n = 0; n < this.nvar; ++n) {
            this.Ytemp[n] = dArray[n] + d2 * (0.029495804398148147 * dArray2[n] + 0.341796875 * this.ak2[n] + 0.041594328703703706 * this.ak3[n] + 0.40034541377314814 * this.ak4[n] + 0.061767578125 * this.ak5[n]);
        }
        this.derivs(d + 0.875 * d2, this.Ytemp, this.ak6);
        for (n = 0; n < this.nvar; ++n) {
            this.Ytemp[n] = dArray[n] + d2 * (0.09788359788359788 * dArray2[n] + 0.4025764895330113 * this.ak3[n] + 0.21043771043771045 * this.ak4[n] + 0.2891022021456804 * this.ak6[n]);
        }
        for (n = 0; n < this.nvar; ++n) {
            this.Yerr[n] = d2 * (-0.004293774801587311 * dArray2[n] + 0.018668586093857853 * this.ak3[n] + -0.034155026830808066 * this.ak4[n] + -0.019321986607142856 * this.ak5[n] + 0.03910220214568039 * this.ak6[n]);
        }
    }
}

