/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel;

import dr.evolution.tree.NodeRef;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.ParameterReplaceableSubstitutionModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Bounds;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BranchSpecificSubstitutionParameterBranchModel
extends AbstractModel
implements BranchModel {
    private final ParameterReplaceableSubstitutionModel substitutionModel;
    private final TreeModel tree;
    private final List<SubstitutionModel> substitutionModelList;
    private Map<BranchRateModel, CompoundParameter> substitutionParameterMap = new HashMap<BranchRateModel, CompoundParameter>();

    public BranchSpecificSubstitutionParameterBranchModel(String string, List<Parameter> list, List<BranchRateModel> list2, ParameterReplaceableSubstitutionModel parameterReplaceableSubstitutionModel, TreeModel treeModel) {
        super(string);
        this.substitutionModel = parameterReplaceableSubstitutionModel;
        this.tree = treeModel;
        if (list.size() != list2.size()) {
            throw new RuntimeException("Dimension mismatch!");
        }
        this.substitutionModelList = this.constructSubstitutionModels(list, list2);
        for (BranchRateModel branchRateModel : list2) {
            this.addModel(branchRateModel);
        }
    }

    private List<SubstitutionModel> constructSubstitutionModels(List<Parameter> list, List<BranchRateModel> list2) {
        ArrayList<SubstitutionModel> arrayList = new ArrayList<SubstitutionModel>();
        for (int i = 0; i < this.tree.getNodeCount(); ++i) {
            ArrayList<Parameter> arrayList2 = new ArrayList<Parameter>();
            for (int j = 0; j < list2.size(); ++j) {
                Parameter parameter = list.get(j);
                ProxySubstitutionParameter proxySubstitutionParameter = new ProxySubstitutionParameter(list2.get(j), this.tree, parameter, i);
                this.mapParamter(list2.get(j), proxySubstitutionParameter);
                arrayList2.add(proxySubstitutionParameter);
            }
            arrayList.add(this.substitutionModel.factory(list, arrayList2));
        }
        return arrayList;
    }

    public CompoundParameter getBranchSpecificParameters(BranchRateModel branchRateModel) {
        return this.substitutionParameterMap.get(branchRateModel);
    }

    private void mapParamter(BranchRateModel branchRateModel, Parameter parameter) {
        CompoundParameter compoundParameter = this.substitutionParameterMap.get(branchRateModel);
        if (compoundParameter == null) {
            compoundParameter = new CompoundParameter("branchSpecific." + branchRateModel.getId());
            this.substitutionParameterMap.put(branchRateModel, compoundParameter);
        }
        compoundParameter.addParameter(parameter);
    }

    @Override
    public BranchModel.Mapping getBranchModelMapping(final NodeRef nodeRef) {
        return new BranchModel.Mapping(){

            @Override
            public int[] getOrder() {
                return new int[]{nodeRef.getNumber()};
            }

            @Override
            public double[] getWeights() {
                return new double[]{1.0};
            }
        };
    }

    @Override
    public List<SubstitutionModel> getSubstitutionModels() {
        return this.substitutionModelList;
    }

    public SubstitutionModel getSubstitutionModel(NodeRef nodeRef) {
        return this.substitutionModelList.get(nodeRef.getNumber());
    }

    @Override
    public SubstitutionModel getRootSubstitutionModel() {
        return this.substitutionModelList.get(this.tree.getRoot().getNumber());
    }

    @Override
    public FrequencyModel getRootFrequencyModel() {
        return this.getRootSubstitutionModel().getFrequencyModel();
    }

    @Override
    public boolean requiresMatrixConvolution() {
        return false;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged(object, n);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    private class ProxySubstitutionParameter
    extends Parameter.Proxy
    implements ModelListener {
        private final BranchRateModel branchRateModel;
        private final int nodeNum;
        private final TreeModel tree;
        private final Parameter rootParameter;

        ProxySubstitutionParameter(BranchRateModel branchRateModel, TreeModel treeModel, Parameter parameter, int n) {
            super(null, 1);
            this.branchRateModel = branchRateModel;
            this.nodeNum = n;
            this.tree = treeModel;
            this.rootParameter = parameter;
            branchRateModel.addModelListener(this);
            BranchSpecificSubstitutionParameterBranchModel.this.addVariable(parameter);
        }

        @Override
        public double getParameterValue(int n) {
            assert (n == 0);
            NodeRef nodeRef = this.tree.getNode(this.nodeNum);
            if (this.tree.isRoot(nodeRef)) {
                return this.rootParameter.getParameterValue(0);
            }
            return this.branchRateModel.getBranchRate(this.tree, this.tree.getNode(this.nodeNum));
        }

        @Override
        public void setParameterValue(int n, double d) {
        }

        @Override
        public void setParameterValueQuietly(int n, double d) {
        }

        @Override
        public void setParameterValueNotifyChangedAll(int n, double d) {
        }

        @Override
        public void addBounds(Bounds<Double> bounds) {
        }

        @Override
        public void modelChangedEvent(Model model, Object object, int n) {
            this.fireParameterChangedEvent();
        }

        @Override
        public void modelRestored(Model model) {
        }
    }
}

