/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.math.Binomial;
import dr.util.ComparableDouble;
import dr.util.HeapSort;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class VeryOldCoalescentLikelihood
extends AbstractModelLikelihood
implements Units {
    public static final String COALESCENT_LIKELIHOOD = "veryOldCoalescentLikelihood";
    public static final String ANALYTICAL = "analytical";
    public static final String MODEL = "model";
    public static final String POPULATION_TREE = "populationTree";
    public static final int COALESCENT = 0;
    public static final int NEW_SAMPLE = 1;
    public static final int NOTHING = 2;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("model", new XMLSyntaxRule[]{new ElementRule(DemographicModel.class)}), new ElementRule("populationTree", new XMLSyntaxRule[]{new ElementRule(TreeModel.class)})};

        @Override
        public String getParserName() {
            return VeryOldCoalescentLikelihood.COALESCENT_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) {
            XMLObject xMLObject2 = xMLObject.getChild(VeryOldCoalescentLikelihood.MODEL);
            DemographicModel demographicModel = (DemographicModel)xMLObject2.getChild(DemographicModel.class);
            xMLObject2 = xMLObject.getChild(VeryOldCoalescentLikelihood.POPULATION_TREE);
            TreeModel treeModel = (TreeModel)xMLObject2.getChild(TreeModel.class);
            return new VeryOldCoalescentLikelihood(treeModel, demographicModel);
        }

        @Override
        public String getParserDescription() {
            return "This element represents the likelihood of the tree given the demographic function.";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    DemographicModel demoModel = null;
    Tree tree = null;
    double[] intervals;
    private double[] storedIntervals;
    int[] lineageCounts;
    private int[] storedLineageCounts;
    boolean intervalsKnown = false;
    protected boolean storedIntervalsKnown = false;
    double logLikelihood;
    protected double storedLogLikelihood;
    boolean likelihoodKnown = false;
    protected boolean storedLikelihoodKnown = false;
    int intervalCount = 0;
    private int storedIntervalCount = 0;

    public VeryOldCoalescentLikelihood(Tree tree, DemographicModel demographicModel) {
        this(COALESCENT_LIKELIHOOD, tree, demographicModel, true);
    }

    public VeryOldCoalescentLikelihood(String string, Tree tree, DemographicModel demographicModel, boolean bl) {
        super(string);
        this.tree = tree;
        this.demoModel = demographicModel;
        if (tree instanceof TreeModel) {
            this.addModel((TreeModel)tree);
        }
        if (demographicModel != null) {
            this.addModel(demographicModel);
        }
        if (bl) {
            this.setupIntervals();
        }
        this.addStatistic(new DeltaStatistic());
    }

    VeryOldCoalescentLikelihood(String string) {
        super(string);
    }

    public NodeRef getMRCAOfCoalescent(Tree tree) {
        return tree.getRoot();
    }

    public NodeRef[] getExcludedMRCAs(Tree tree) {
        return null;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.tree) {
            this.intervalsKnown = false;
        }
        this.likelihoodKnown = false;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
        System.arraycopy(this.intervals, 0, this.storedIntervals, 0, this.intervals.length);
        System.arraycopy(this.lineageCounts, 0, this.storedLineageCounts, 0, this.lineageCounts.length);
        this.storedIntervalsKnown = this.intervalsKnown;
        this.storedIntervalCount = this.intervalCount;
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        System.arraycopy(this.storedIntervals, 0, this.intervals, 0, this.storedIntervals.length);
        System.arraycopy(this.storedLineageCounts, 0, this.lineageCounts, 0, this.storedLineageCounts.length);
        this.intervalsKnown = this.storedIntervalsKnown;
        this.intervalCount = this.storedIntervalCount;
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
        if (!this.intervalsKnown) {
            this.likelihoodKnown = false;
        }
    }

    @Override
    protected final void acceptState() {
    }

    protected final void adoptState(Model model) {
        this.makeDirty();
    }

    @Override
    public final Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public final void makeDirty() {
        this.likelihoodKnown = false;
        this.intervalsKnown = false;
    }

    public double calculateLogLikelihood() {
        if (!this.intervalsKnown) {
            this.setupIntervals();
        }
        if (this.demoModel == null) {
            return this.calculateAnalyticalLogLikelihood();
        }
        double d = 0.0;
        double d2 = 0.0;
        DemographicFunction demographicFunction = this.demoModel.getDemographicFunction();
        for (int i = 0; i < this.intervalCount; ++i) {
            d += this.calculateIntervalLikelihood(demographicFunction, this.intervals[i], d2, this.lineageCounts[i], this.getIntervalType(i));
            int n = this.getCoalescentEvents(i) - 1;
            for (int j = 0; j < n; ++j) {
                d += this.calculateIntervalLikelihood(demographicFunction, 0.0, d2, this.lineageCounts[i] - j - 1, 0);
            }
            d2 += this.intervals[i];
        }
        return d;
    }

    private double calculateAnalyticalLogLikelihood() {
        double d = this.getLambda();
        int n = this.tree.getExternalNodeCount();
        double d2 = Math.log(1.0 / Math.pow(d, n - 1));
        return d2;
    }

    public final double calculateIntervalLikelihood(DemographicFunction demographicFunction, double d, double d2, int n) {
        return this.calculateIntervalLikelihood(demographicFunction, d, d2, n, 0);
    }

    public final double calculateIntervalLikelihood(DemographicFunction demographicFunction, double d, double d2, int n, int n2) {
        double d3 = d + d2;
        double d4 = demographicFunction.getIntegral(d2, d3);
        double d5 = 0.0;
        switch (n2) {
            case 0: {
                d5 = -Math.log(demographicFunction.getDemographic(d3)) - Binomial.choose2(n) * d4;
                break;
            }
            case 1: {
                d5 = -(Binomial.choose2(n) * d4);
            }
        }
        return d5;
    }

    private double getLambda() {
        double d = 0.0;
        for (int i = 0; i < this.getIntervalCount(); ++i) {
            d += this.intervals[i] * (double)this.lineageCounts[i];
        }
        return d /= 2.0;
    }

    protected final void setupIntervals() {
        double d = 1.0E-9;
        ArrayList arrayList = new ArrayList();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        VeryOldCoalescentLikelihood.collectAllTimes(this.tree, this.getMRCAOfCoalescent(this.tree), this.getExcludedMRCAs(this.tree), arrayList, arrayList2);
        int[] nArray = new int[arrayList.size()];
        HeapSort.sort(arrayList, nArray);
        int n = this.tree.getNodeCount();
        if (this.intervals == null) {
            this.intervals = new double[n];
            this.lineageCounts = new int[n];
            this.storedIntervals = new double[n];
            this.storedLineageCounts = new int[n];
        }
        double d2 = ((ComparableDouble)arrayList.get(nArray[0])).doubleValue();
        int n2 = 0;
        int n3 = 0;
        this.intervalCount = 0;
        while (n3 < arrayList.size()) {
            double d3;
            int n4 = 0;
            int n5 = 0;
            double d4 = d3 = ((ComparableDouble)arrayList.get(nArray[n3])).doubleValue();
            while (Math.abs(d4 - d3) < d) {
                int n6 = arrayList2.get(nArray[n3]);
                if (n6 == 0) {
                    ++n5;
                } else {
                    n4 += n6 - 1;
                }
                if (++n3 >= arrayList.size()) break;
                d4 = ((ComparableDouble)arrayList.get(nArray[n3])).doubleValue();
            }
            if (n5 > 0) {
                if (this.intervalCount > 0 || d3 - d2 > d) {
                    this.intervals[this.intervalCount] = d3 - d2;
                    this.lineageCounts[this.intervalCount] = n2;
                    ++this.intervalCount;
                }
                d2 = d3;
            }
            n2 += n5;
            if (n4 > 0) {
                this.intervals[this.intervalCount] = d3 - d2;
                this.lineageCounts[this.intervalCount] = n2;
                ++this.intervalCount;
                d2 = d3;
            }
            n2 -= n4;
        }
        this.intervalsKnown = true;
    }

    private static void collectAllTimes(Tree tree, NodeRef nodeRef, NodeRef[] nodeRefArray, ArrayList arrayList, ArrayList<Integer> arrayList2) {
        arrayList.add(new ComparableDouble(tree.getNodeHeight(nodeRef)));
        arrayList2.add(tree.getChildCount(nodeRef));
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, i);
            if (nodeRefArray == null) {
                VeryOldCoalescentLikelihood.collectAllTimes(tree, nodeRef2, nodeRefArray, arrayList, arrayList2);
                continue;
            }
            boolean bl = true;
            for (NodeRef nodeRef3 : nodeRefArray) {
                if (nodeRef3.getNumber() != nodeRef2.getNumber()) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            VeryOldCoalescentLikelihood.collectAllTimes(tree, nodeRef2, nodeRefArray, arrayList, arrayList2);
        }
    }

    public final int getIntervalCount() {
        return this.intervalCount;
    }

    public final double getInterval(int n) {
        if (n >= this.intervalCount) {
            throw new IllegalArgumentException();
        }
        return this.intervals[n];
    }

    public final int getLineageCount(int n) {
        if (n >= this.intervalCount) {
            throw new IllegalArgumentException();
        }
        return this.lineageCounts[n];
    }

    public final int getCoalescentEvents(int n) {
        if (n >= this.intervalCount) {
            throw new IllegalArgumentException();
        }
        if (n < this.intervalCount - 1) {
            return this.lineageCounts[n] - this.lineageCounts[n + 1];
        }
        return this.lineageCounts[n] - 1;
    }

    public final int getIntervalType(int n) {
        if (n >= this.intervalCount) {
            throw new IllegalArgumentException();
        }
        int n2 = this.getCoalescentEvents(n);
        if (n2 > 0) {
            return 0;
        }
        if (n2 < 0) {
            return 1;
        }
        return 2;
    }

    public final double getTotalHeight() {
        double d = 0.0;
        for (int i = 0; i < this.intervalCount; ++i) {
            d += this.intervals[i];
        }
        return d;
    }

    public final boolean isBinaryCoalescent() {
        for (int i = 0; i < this.intervalCount; ++i) {
            if (this.getCoalescentEvents(i) == 1) continue;
            return false;
        }
        return true;
    }

    public final boolean isCoalescentOnly() {
        for (int i = 0; i < this.intervalCount; ++i) {
            if (this.getCoalescentEvents(i) >= 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return Double.toString(this.getLogLikelihood());
    }

    @Override
    public final Units.Type getUnits() {
        return this.demoModel.getUnits();
    }

    @Override
    public void setUnits(Units.Type type) {
        this.demoModel.setUnits(type);
    }

    public class DeltaStatistic
    extends Statistic.Abstract {
        public DeltaStatistic() {
            super("delta");
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public double getStatisticValue(int n) {
            throw new RuntimeException("Not implemented");
        }
    }
}

