% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginalLikelihood.R
\name{bridgesample}
\alias{bridgesample}
\title{Calculates the marginal likelihood of a chain via bridge sampling}
\usage{
bridgesample(chain, nParams, lower = NULL, upper = NULL, posterior, ...)
}
\arguments{
\item{chain}{a single mcmc chain with samples as rows and parameters and posterior density as columns.}

\item{nParams}{number of parameters}

\item{lower}{optional - lower bounds of the prior}

\item{upper}{optional - upper bounds of the prior}

\item{posterior}{posterior density function}

\item{...}{arguments passed to bridge_sampler}
}
\description{
Calculates the marginal likelihood of a chain via bridge sampling
}
\details{
This function uses "bridge_sampler" from the package "bridgesampling".
}
\examples{
means <- c(0, 1, 2)
sds <- c(1, 0.6, 3)

# log-likelihood
ll <- function (x) {
  return(sum(dnorm(x, mean = means, sd = sds, log = TRUE)))
}

# lower and upper bounds for prior
lb <- rep(-10, 3)
ub <- rep(10, 3)

# create setup and run MCMC
setup <- createBayesianSetup(likelihood = ll,
                             lower = lb,
                             upper = ub)

out <- runMCMC(bayesianSetup = setup,
               settings = list(iterations = 1000),
               sampler = "DEzs")

# sample from MCMC output with "burn-in" of 25\%
sample <- getSample(out$chain, start = 250, numSamples = 500)

# use bridge sampling to get marginal likelihood
bs_result <- bridgesample(chain = sample,
                          nParams = out$setup$numPars,
                          lower = lb,
                          upper = ub,
                          posterior = out$setup$posterior$density)
bs_result
}
\seealso{
\code{\link{marginalLikelihood}}
}
\author{
Tankred Ott
}
\keyword{internal}
