% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{metadata_srsc_per_image}
\alias{metadata_srsc_per_image}
\title{Create metadata for MRMC data.}
\usage{
metadata_srsc_per_image(dataList, ModifiedPoisson)
}
\arguments{
\item{dataList}{A list, should include
 \code{m,q,c,h,f,NL,C,M,Q} which means

\code{c}  should be
created by \code{  c <-c(rep(C:1))},
where \code{C} is the number of confidence levels.
So, you should write down your hits
and false alarms vector so that it
is compatible with this
automatically created \code{c} vector.

\code{h} means the number of hits

\code{f} means the number of false alarm

\code{NL} means the Total number of lesions for all images

\code{C} means the highest number of confidence level}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}.

If \code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \strong{\emph{per lesion}},
and a model is fitted
so that the FROC curve is an expected curve
 of points consisting of the pairs of TPF per lesion and FPF  \strong{\emph{per lesion}}.

Similarly,

If \code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \strong{\emph{per image}},
and a model is fitted
so that the FROC curve is an expected curve
 of points consisting of the pair of TPF per lesion and FPF  \strong{\emph{per image}}.



For more details, see the author's paper in which I explained \emph{per image} and \emph{per lesion}.
(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  }, now, it is omiited from this package, because the size of vignettes are large.)

If \code{ModifiedPoisson = TRUE},
 then the \emph{False Positive Fraction (FPF)} is defined as follows
 (\eqn{F_c} denotes the number of false alarms with confidence level \eqn{c} )


\deqn{ \frac{F_1+F_2+F_3+F_4+F_5}{N_L}, }

\deqn{ \frac{F_2+F_3+F_4+F_5}{N_L}, }

 \deqn{ \frac{F_3+F_4+F_5}{N_L}, }

  \deqn{ \frac{F_4+F_5}{N_L}, }

   \deqn{ \frac{F_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).
To emphasize its denominator  \eqn{N_L},
we also call it the \emph{False Positive Fraction (FPF)} \strong{per lesion}.


On the other hand,


if \code{ModifiedPoisson = FALSE} (Default), then
\emph{False Positive Fraction (FPF)} is given by

\deqn{ \frac{F_1+F_2+F_3+F_4+F_5}{N_I}, }

\deqn{ \frac{F_2+F_3+F_4+F_5}{N_I}, }

 \deqn{ \frac{F_3+F_4+F_5}{N_I}, }

  \deqn{ \frac{F_4+F_5}{N_I}, }

   \deqn{ \frac{F_5}{N_I}, }

where \eqn{N_I} is the number of images (trial).
To emphasize its denominator \eqn{N_I},
we also call it the \emph{False Positive Fraction (FPF)} \strong{per image}.


The model is fitted so that
the estimated FROC curve can be ragraded
 as the expected pairs of   FPF per image and TPF per lesion (\code{ModifiedPoisson = FALSE })

 or as the expected pairs of   FPF per image and TPF per lesion  (\code{ModifiedPoisson = TRUE})

If \code{ModifiedPoisson = TRUE}, then FROC curve means the expected pair of FPF \strong{per lesion} and TPF.

On the other hand, if  \code{ModifiedPoisson = FALSE}, then FROC curve means the expected pair of \strong{FPF per image} and TPF.




So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it uses only per images (trial). Since we can divide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author also developed FROC theory to consider FROC analysis under per signal.
One can see that the FROC curve is rigid with respect to change of a number of images, so, it does not matter whether \code{ModifiedPoisson = TRUE} or \code{FALSE}.
This rigidity of curves means that the number of images is redundant parameter for the FROC trial and
thus the author try to exclude it.


Revised 2019 Dec 8
Revised 2019 Nov 25
Revised 2019 August 28}
}
\value{
A metadata such as number
of cumulative false alarms and
 hits to create and draw the curve.
}
\description{
The so-called \emph{false positive fraction (FPF)}
and the       \emph{true  positive fraction (TPF)}
are calculated from the number of hits (True Positives: TPs)
and the number of false alarms (False Positives: FPs)
}
\details{
From data of number of hits (True Positive: TP)
and false alarms (False Positive: FP), we calculate the number
of cumulative false positives (FPF) and cumulative hits (TPF).

Because there are three subscripts,
 reader, modality, and image,
 we create array format and vector format etc...
}
\examples{
\dontrun{
#========================================================================================
#                      TP and FP
#========================================================================================


        dat  <- BayesianFROC::dataList.Chakra.Web



#========================================================================================
#              Calculates  TPF and FPF from TP and FP
#========================================================================================


             metadata_srsc_per_image(dat)






# Revised 2019 Nov.


}# dottest
}
