% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawCurves.R
\name{plot_empirical_FROC_curves}
\alias{plot_empirical_FROC_curves}
\title{Plot empirical FROC Curves by traditional ways of \pkg{ggplot2}}
\usage{
plot_empirical_FROC_curves(
  dataList.MRMC,
  ModifiedPoisson = FALSE,
  colored_by_modality = TRUE,
  numbered_by_modality = TRUE,
  cex = 1.3,
  modalityID = c(1, dataList.MRMC$M),
  readerID = c(1, dataList.MRMC$Q)
)
}
\arguments{
\item{dataList.MRMC}{A list, indicating FROC data of MRMC.
See also \code{dataList} which is a variable of the function \code{\link{fit_Bayesian_FROC}()}.}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}.

If \code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \strong{\emph{per lesion}},
and model is fitted
so that the FROC curve is an expected curve
 of points consisting of the pairs of TPF per lesion and FPF  \strong{\emph{per lesion}}.

Similarly,

If \code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \strong{\emph{per image}},
and model is fitted
so that the FROC curve is an expected curve
 of points consisting of the pair of TPF per lesion and FPF  \strong{\emph{per image}}.



For more details, see the author's paper in which I explained \emph{per image} and \emph{per lesion}.
(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  }, now, it is omiited from this package, because the size of vignettes are large.)

If \code{ModifiedPoisson = TRUE},
 then the \emph{False Positive Fraction (FPF)} is defined as follows
 (\eqn{F_c} denotes the number of false alarms with confidence level \eqn{c} )


\deqn{ \frac{F_1+F_2+F_3+F_4+F_5}{N_L}, }

\deqn{ \frac{F_2+F_3+F_4+F_5}{N_L}, }

 \deqn{ \frac{F_3+F_4+F_5}{N_L}, }

  \deqn{ \frac{F_4+F_5}{N_L}, }

   \deqn{ \frac{F_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).
To emphasize its denominator  \eqn{N_L},
we also call it the \emph{False Positive Fraction (FPF)} \strong{per lesion}.


On the other hand,


if \code{ModifiedPoisson = FALSE} (Default), then
\emph{False Positive Fraction (FPF)} is given by

\deqn{ \frac{F_1+F_2+F_3+F_4+F_5}{N_I}, }

\deqn{ \frac{F_2+F_3+F_4+F_5}{N_I}, }

 \deqn{ \frac{F_3+F_4+F_5}{N_I}, }

  \deqn{ \frac{F_4+F_5}{N_I}, }

   \deqn{ \frac{F_5}{N_I}, }

where \eqn{N_I} is the number of images (trial).
To emphasize its denominator \eqn{N_I},
we also call it the \emph{False Positive Fraction (FPF)} \strong{per image}.


The model is fitted so that
the estimated FROC curve can be ragraded
 as the expected pairs of   FPF per image and TPF per lesion (\code{ModifiedPoisson = FALSE })

 or as the expected pairs of   FPF per image and TPF per lesion  (\code{ModifiedPoisson = TRUE})

If \code{ModifiedPoisson = TRUE}, then FROC curve means the expected pair of FPF \strong{per lesion} and TPF.

On the other hand, if  \code{ModifiedPoisson = FALSE}, then FROC curve means the expected pair of \strong{FPF per image} and TPF.




So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it uses only per images (trial). Since we can divide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author also developed FROC theory to consider FROC analysis under per signal.
One can see that the FROC curve is rigid with respect to change of a number of images, so, it does not matter whether \code{ModifiedPoisson = TRUE} or \code{FALSE}.
This rigidity of curves means that the number of images is redundant parameter for the FROC trial and
thus the author try to exclude it.


Revised 2019 Dec 8
Revised 2019 Nov 25
Revised 2019 August 28}

\item{colored_by_modality}{A logical, if TRUE, then the color in the scatter plot means modality ID.
If not, then the each color in the scatter plot indicates reader ID.}

\item{numbered_by_modality}{A logical, if TRUE, then the number in the scatter plot means modality ID.
If not, then the each number in the scatter plot indicates reader ID.}

\item{cex}{A positive real number, specifying the size of dots in the resulting plot.}

\item{modalityID}{A vector of integer, specifying modality ID to be drawn.}

\item{readerID}{A vector of integer, specifying modality ID to be drawn.}
}
\value{
An object made by ggplot2, I am not sure what it is.
}
\description{
Plot empirical FROC Curves.
}
\examples{
\dontrun{
#========================================================================================
#                               The 1-st example
#========================================================================================


plot_empirical_FROC_curves(dd,readerID = 1:4,modalityID = 1:5)
plot_empirical_FROC_curves(dd,readerID = 1,modalityID = c(4,3))
plot_empirical_FROC_curves(dd,readerID = 2,modalityID = c(4,3))
plot_empirical_FROC_curves(dd,readerID = 3,modalityID = c(4,3))
plot_empirical_FROC_curves(dd,readerID = 4,modalityID = c(4,3))







#========================================================================================
#                               The  example
#========================================================================================


     v  <- v_truth_creator_for_many_readers_MRMC_data(M=2,Q=37)
 m  <- mu_truth_creator_for_many_readers_MRMC_data(M=2,Q=37)
 d  <- create_dataList_MRMC(mu.truth = m,v.truth = v)


    plot_empirical_FROC_curves(d,readerID = 1:14,modalityID = 1:2)


    plot_empirical_FROC_curves(d,readerID = 1:24,modalityID = 1:2)


    plot_empirical_FROC_curves(d,readerID = 1:34,modalityID = 1:2)



#========================================================================================
#                               The  example
#========================================================================================



v  <- v_truth_creator_for_many_readers_MRMC_data(M=2,Q=7)
m  <- mu_truth_creator_for_many_readers_MRMC_data(M=2,Q=7)
d  <- create_dataList_MRMC(mu.truth = m,v.truth = v)


plot_empirical_FROC_curves(d,readerID = 1,modalityID = 1:2)
plot_empirical_FROC_curves(d,readerID = 2,modalityID = 1:2)
plot_empirical_FROC_curves(d,readerID = 3,modalityID = 1:2)
plot_empirical_FROC_curves(d,readerID = 4,modalityID = 1:2)
plot_empirical_FROC_curves(d,readerID = 5,modalityID = 1:2)
plot_empirical_FROC_curves(d,readerID = 6,modalityID = 1:2)
plot_empirical_FROC_curves(d,readerID = 7,modalityID = 1:2)

#========================================================================================
#                               The  example
#========================================================================================


plot_empirical_FROC_curves(dd)
plot_empirical_FROC_curves(dd,modalityID = c(3,5))
plot_empirical_FROC_curves(dd,modalityID = c(3,5),readerID = c(1,4))
plot_empirical_FROC_curves(dd,modalityID = c(3,5),readerID = c(1,3))
plot_empirical_FROC_curves(dd,modalityID = c(3,5),readerID = c(1,2,3))
plot_empirical_FROC_curves(dd,modalityID = c(3,5),readerID = c(1,2,3))
plot_empirical_FROC_curves(dd,modalityID = c(3,5),readerID = c(3))
plot_empirical_FROC_curves(dd,modalityID = c(3,5),readerID = c(1,2,3))
plot_empirical_FROC_curves(dd,modalityID = c(3,5),readerID = c(1,2))
plot_empirical_FROC_curves(dd,modalityID = c(3,5),readerID = c(2))
plot_empirical_FROC_curves(dd,modalityID = c(3),readerID = c(2))
plot_empirical_FROC_curves(dd,modalityID = c(5),readerID = c(2))







}

}
