% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document_dataset_MRMC.R
\docType{data}
\name{dd}
\alias{dd}
\title{Multiple Reader and Multiple Modality Data}
\description{
A list, representing FROC data of MRMC. This is same as \code{\link{dataList.Chakra.Web} }.
}
\details{
This data is based on in Chakraborty's JAFROC software
in which example data exists.
 The author have calculated hits and false alarms
 from this Jafroc example data.



\strong{\emph{ Contents:  }}

 \emph{          Multiple readers and multiple modalities case, i.e., MRMC case   }




---------------------------------------------------------------------------------------------------
\tabular{ccccc}{
 \strong{ModalityID } \tab   \strong{ReaderID }  \tab  \strong{ Confidence levels} \tab   \strong{No. of false alarms} \tab   \strong{No. of hits}.\cr
  \code{q} \tab  \code{ m}  \tab   \code{c} \tab  \code{ f} \tab \code{ h}\cr
  -------------- \tab ------------- \tab ------------------------ \tab  ------------------- \tab ----------------\cr
1\tab 1\tab 5\tab  0\tab 50\cr
1\tab 1\tab 4\tab  4\tab 30\cr
1\tab 1\tab 3\tab 20\tab 11\cr
1\tab 1\tab 2\tab 29\tab 5\cr
1\tab 1\tab 1\tab 21\tab 1\cr
1\tab 2\tab 5\tab  0\tab 15\cr
1\tab 2\tab 4\tab  0\tab 29\cr
1\tab 2\tab 3\tab  6\tab 29\cr
1\tab 2\tab 2\tab 15\tab 1\cr
1\tab 2\tab 1\tab 22\tab 0\cr
1\tab 3\tab 5\tab  1\tab 39\cr
1\tab 3\tab 4\tab 15\tab 31\cr
1\tab 3\tab 3\tab 18\tab 8\cr
1\tab 3\tab 2\tab 31\tab 10\cr
1\tab 3\tab 1\tab 19\tab 3\cr
1\tab 4\tab 5\tab  1\tab 10\cr
1\tab 4\tab 4\tab  2\tab 8\cr
1\tab 4\tab 3\tab  4\tab 25\cr
1\tab 4\tab 2\tab 16\tab 45\cr
1\tab 4\tab 1\tab 17\tab 14\cr
2\tab 1\tab 5\tab  1\tab 52\cr
2\tab 1\tab 4\tab  1\tab 25\cr
2\tab 1\tab 3\tab 21\tab 13\cr
2\tab 1\tab 2\tab 24\tab 4\cr
2\tab 1\tab 1\tab 23\tab 1\cr
2\tab 2\tab 5\tab  1\tab 27\cr
2\tab 2\tab 4\tab  1\tab 28\cr
2\tab 2\tab 3\tab  5\tab 29\cr
2\tab 2\tab 2\tab 30\tab 1\cr
2\tab 2\tab 1\tab 40\tab 0\cr
2\tab 3\tab 5\tab  2\tab 53\cr
2\tab 3\tab 4\tab 19\tab 29\cr
2\tab 3\tab 3\tab 31\tab 13\cr
2\tab 3\tab 2\tab 56\tab 2\cr
2\tab 3\tab 1\tab 42\tab 4\cr
2\tab 4\tab 5\tab  2\tab 9\cr
2\tab 4\tab 4\tab  0\tab 16\cr
2\tab 4\tab 3\tab  2\tab 22\cr
2\tab 4\tab 2\tab 30\tab 43\cr
2\tab 4\tab 1\tab 32\tab 14\cr
3\tab 1\tab 5\tab  1\tab 43\cr
3\tab 1\tab 4\tab  7\tab 29\cr
3\tab 1\tab 3\tab 13\tab 11\cr
3\tab 1\tab 2\tab 28\tab 6\cr
3\tab 1\tab 1\tab 19\tab 0\cr
3\tab 2\tab 5\tab  0\tab 18\cr
3\tab 2\tab 4\tab  1\tab 29\cr
3\tab 2\tab 3\tab  7\tab 21\cr
3\tab 2\tab 2\tab  7\tab 0\cr
3\tab 2\tab 1\tab 31\tab 0\cr
3\tab 3\tab 5\tab  7\tab 43\cr
3\tab 3\tab 4\tab 15\tab 29\cr
3\tab 3\tab 3\tab 28\tab 6\cr
3\tab 3\tab 2\tab 41\tab 7\cr
3\tab 3\tab 1\tab  9\tab 1\cr
3\tab 4\tab 5\tab  0\tab 10\cr
3\tab 4\tab 4\tab  2\tab 14\cr
3\tab 4\tab 3\tab  5\tab 19\cr
3\tab 4\tab 2\tab 24\tab 32\cr
3\tab 4\tab 1\tab 31\tab 23\cr
4\tab 1\tab 5\tab  1\tab 61\cr
4\tab 1\tab 4\tab  4\tab 19\cr
4\tab 1\tab 3\tab 18\tab 12\cr
4\tab 1\tab 2\tab 21\tab 9\cr
4\tab 1\tab 1\tab 23\tab 3\cr
4\tab 2\tab 5\tab  1\tab 16\cr
4\tab 2\tab 4\tab  1\tab 29\cr
4\tab 2\tab 3\tab  0\tab 34\cr
4\tab 2\tab 2\tab 11\tab 1\cr
4\tab 2\tab 1\tab 35\tab 0\cr
4\tab 3\tab 5\tab  6\tab 52\cr
4\tab 3\tab 4\tab 14\tab 29\cr
4\tab 3\tab 3\tab 37\tab 10\cr
4\tab 3\tab 2\tab 36\tab 4\cr
4\tab 3\tab 1\tab 18\tab 3\cr
4\tab 4\tab 5\tab  0\tab 10\cr
4\tab 4\tab 4\tab  2\tab 16\cr
4\tab 4\tab 3\tab  4\tab 23\cr
4\tab 4\tab 2\tab 18\tab 43\cr
4\tab 4\tab 1\tab 25\tab 15\cr
5\tab 1\tab 5\tab  0\tab 35\cr
5\tab 1\tab 4\tab  2\tab 29\cr
5\tab 1\tab 3\tab 19\tab 18\cr
5\tab 1\tab 2\tab 23\tab 9\cr
5\tab 1\tab 1\tab 18\tab 0\cr
5\tab 2\tab 5\tab  0\tab 17\cr
5\tab 2\tab 4\tab  2\tab 27\cr
5\tab 2\tab 3\tab  6\tab 24\cr
5\tab 2\tab 2\tab 10\tab 0\cr
5\tab 2\tab 1\tab 30\tab 0\cr
5\tab 3\tab 5\tab  2\tab 34\cr
5\tab 3\tab 4\tab 25\tab 33\cr
5\tab 3\tab 3\tab 40\tab 7\cr
5\tab 3\tab 2\tab 29\tab 13\cr
5\tab 3\tab 1\tab 24\tab 2\cr
5\tab 4\tab 5\tab  1\tab 12\cr
5\tab 4\tab 4\tab  1\tab 16\cr
5\tab 4\tab 3\tab  4\tab 21\cr
5\tab 4\tab 2\tab 24\tab 35\cr
5\tab 4\tab 1\tab 32\tab 15}
---------------------------------------------------------------------------------------------------
}
\examples{


    viewdata(BayesianFROC::dd)


#========================================================================================
#   dd  is same as dataList.Chakra.Web,  since the following code is all TRUE
#========================================================================================

    dd$f==dataList.Chakra.Web$f







#========================================================================================
#                           Code to make the dataset dd
#========================================================================================






h<-c(
  50,30,11,5,1,15,29,29,1,0,39,31,8 ,10,3,10,8 ,25,45,14, # modality 1
  52,25,13,4,1,27,28,29,1,0,53,29,13,2 ,4,9 ,16,22,43,14, # modality 2
  43,29,11,6,0,18,29,21,0,0,43,29,6 ,7 ,1,10,14,19,32,23, # modality 3
  61,19,12,9,3,16,29,34,1,0,52,29,10,4 ,3,10,16,23,43,15, # modality 4
  35,29,18,9,0,17,27,24,0,0,34,33,7 ,13,2,12,16,21,35,15  # modality 5
)

f <-c(
  0 ,4,20,29,21,0,0,6,15,22,1 ,15,18,31,19,1,2,4,16,17,# modality 1
  1 ,1,21,24,23,1,1,5,30,40,2 ,19,31,56,42,2,0,2,30,32,# modality 2
  1, 7,13,28,19,0,1,7, 7,31, 7,15,28,41,9 ,0,2,5,24,31,# modality 3
  1, 4,18,21,23,1,1,0,11,35, 6,14,37,36,18,0,2,4,18,25,# modality 4
  0, 2,19,23,18,0,2,6,10,30, 2,25,40,29,24,1,1,4,24,32)# modality 5

a   <- m_q_c_vector_from_M_Q_C(5,4,5)

m <- a$m
c <- a$c
q <- a$q

NI<-199
NL <-142
C<-5
M<-5
Q<-4

dd <- list(
  h=h,
  f=f,
  m=m,
  c=c,
  q=q,
  NI=NI,
  NL=NL,
  M=M,
  Q=Q,
  C=C
)





}
\references{
Example data of Jafroc software
}
\seealso{
\code{\link{dataList.Chakra.Web} }
 \code{\link{dataList.Chakra.Web.orderd} }
  \code{\link{d} }
}
\author{
Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
}
