% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_mesh.R
\name{make_mesh}
\alias{make_mesh}
\title{Make Mesh}
\usage{
make_mesh(vertices, faces, use_INLA = TRUE)
}
\arguments{
\item{vertices}{A \eqn{V \times 3} matrix, where each row contains the Euclidean
coordinates at which a given vertex in the mesh is located. \eqn{V} is the
number of vertices in the mesh}

\item{faces}{An \eqn{F \times 3} matrix, where each row contains the vertex
indices for a given triangular face in the mesh. \eqn{F} is the number of
faces in the mesh.}

\item{use_INLA}{(logical) Use the INLA package to make the mesh? Default:
\code{TRUE}. Otherwise, mesh construction is based on an internal function,
\code{galerkin_db}.}
}
\value{
INLA triangular mesh
}
\description{
Make INLA triangular mesh from faces and vertices
}
\section{INLA Requirement}{

This function requires the \code{INLA} package, which is not a CRAN package.
See \url{https://www.r-inla.org/download-install} for easy installation instructions.
}

