% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.BayesSUR.R
\name{coef.BayesSUR}
\alias{coef.BayesSUR}
\title{coef method for class \code{BayesSUR}}
\usage{
\method{coef}{BayesSUR}(object, beta.type = "marginal", Pmax = 0, ...)
}
\arguments{
\item{object}{an object of class \code{BayesSUR}}

\item{beta.type}{type of output beta. Default is \code{marginal}, giving marginal beta estimation. If \code{beta.type="conditional"}, it gives conditional beta estimation}

\item{Pmax}{valid if \code{beta.type="conditional"}, giving estimated beta conditioning on gammas>=\code{Pmax}. If \code{beta.type="conditional"} and \code{Pmax=0.5}, it gives median probability model betas. Default is 0.}

\item{...}{other arguments}
}
\value{
Estimated coefficients are from an object of class \code{BayesSUR}. If the \code{BayesSUR} specified data standardization, the fitted values are base based on standardized data.
}
\description{
Extract the posterior mean of the coefficients of a \code{BayesSUR} class object
}
\examples{
data("exampleQTL", package = "BayesSUR")
hyperpar <- list( a_w = 2 , b_w = 5 )

set.seed(9173)
fit <- BayesSUR(Y = exampleEQTL[["blockList"]][[1]], 
                X = exampleEQTL[["blockList"]][[2]],
                data = exampleEQTL[["data"]], outFilePath = tempdir(),
                nIter = 100, burnin = 50, nChains = 2, gammaPrior = "hotspot",
                hyperpar = hyperpar, tmpFolder = "tmp/" )

## check prediction
beta.hat <- coef(fit)

}
