% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_JoinCount}
\alias{plot_JoinCount}
\title{plot_JoinCount}
\usage{
plot_JoinCount(
  data,
  var_cured = character(),
  var_id = character(),
  var_time = character(),
  n = 1,
  t = 1.645,
  threshold = 800L
)
}
\arguments{
\item{data}{data.}

\item{var_cured}{binary indicator of immunity.}

\item{var_id}{ID's unique identifier.}

\item{var_time}{variable that measures time.}

\item{n}{number of observation per id.}

\item{t}{value of the confidence interval.}

\item{threshold}{distance in kilometers. By default is 800.}
}
\value{
A ggplot object
}
\description{
Uses Join Count tests to assess spatial clustering or dispersion of categorical variables in the data. Negative values indicate positive spatial clustering.
}
\examples{

library(BayesSPsurv)
dataw  <- spduration::add_duration(data = BayesSPsurv::Walter_2015_JCR,
                                   y = "renewed_war",
                                   unitID = "ccode",
                                   tID = "year",
                                   freq = "year",
                                   ongoing = FALSE)


plot_JoinCount(data = dataw,
               var_cured = "cured",
               var_id = "ccode",
               var_time = "year",
               n = 12)


}
