% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pooledSPsurv.R
\name{pooledSPsurv}
\alias{pooledSPsurv}
\alias{summary.SPsurv}
\alias{print.SPsurv}
\alias{plot.SPsurv}
\title{pooledSPsurv}
\usage{
pooledSPsurv(
  duration,
  immune,
  Y0,
  LY,
  data,
  N,
  burn,
  thin,
  w = c(1, 1, 1),
  m = 10,
  form = c("Weibull", "exponential", "loglog")
)

\method{summary}{SPsurv}(object, parameter = character(), ...)

\method{print}{SPsurv}(x, ...)

\method{plot}{SPsurv}(x, parameter = character(), ...)
}
\arguments{
\item{duration}{survival stage equation written in a formula of the form Y ~ X1 + X2 + ... where Y is duration until failure or censoring.}

\item{immune}{split stage equation written in a formula of the form C ~ Z1 + Z2 + ... where C is a binary indicator of immunity.}

\item{Y0}{the elapsed time since inception until the beginning of time period (t-1).}

\item{LY}{last observation year (coded as 1; 0 otherwise) due to censoring or failure.}

\item{data}{data.frame.}

\item{N}{number of MCMC iterations.}

\item{burn}{burn-in to be discarded.}

\item{thin}{thinning to prevent from autocorrelation.}

\item{w}{size of the slice in the slice sampling for (betas, gammas, rho). Write it as a vector. E.g. c(1,1,1).}

\item{m}{limit on steps in the slice sampling. A vector of values for beta, gamma, rho.}

\item{form}{type of parametric model (Weibull, Exponential, or Log-Logistic).}

\item{object}{an object of class \code{SPsurv}, the output of \code{\link{pooledSPsurv}}.}

\item{parameter}{one of Four parameters of the \code{\link{pooledSPsurv}} output. Indicate either "betas," "gammas", "rho" or "delta".}

\item{...}{additional parameter.}

\item{x}{an object of class \code{SPsurv}, the output of \code{\link{pooledSPsurv}}.}
}
\value{
pooledSPsurv returns an object of class \code{"SPsurv"}.

A \code{"pooledSPsurv"} object has the following elements:
\item{betas}{matrix, numeric values of the posterior for each variable in the duration equation .}
\item{gammas}{matrix, numeric values of the posterior for each variable in the immune equation.}
\item{rho}{vector, numeric values of rho.}
\item{delta}{vector, numeric values of delta.}
\item{X}{matrix of X's variables.}
\item{Z}{matrix of Z's variables.}
\item{Y}{vector of `Y'.}
\item{Y0}{vector of `Y0'.}
\item{C}{vector of `C'.}
\item{form}{character, type of distribution.}
\item{call}{description for the model to be estimated.}

list. Empirical mean, standard deviation and quantiles for each variable.

list. Empirical mean, standard deviation and quantiles for each variable.
}
\description{
Markov Chain Monte Carlo (MCMC) to run Bayesian split population survival model with no frailties.

Returns a summary of a SPsurv object via \code{\link[coda]{summary.mcmc}}.

Print method for a \code{\link{pooledSPsurv}} x.

Returns a plot of a pooledSPsurv object via \code{\link[coda]{plot.mcmc}}.
}
\examples{
\donttest{
walter <- spduration::add_duration(Walter_2015_JCR,"renewed_war",
                                   unitID = "ccode", tID = "year",
                                   freq = "year", ongoing = FALSE)

set.seed(123456)

model <-
    pooledSPsurv(
        duration = duration ~ fhcompor1 + lgdpl + comprehensive + victory +
            instabl + intensityln + ethfrac + unpko,
        immune   = cured ~ fhcompor1 + lgdpl + victory,
        Y0       = 't.0',
        LY       = 'lastyear',
        data     = walter,
        N        = 100,
        burn     = 10,
        thin     = 10,
        w        = c(1,1,1),
        m        = 10,
        form     = "Weibull"
    )


print(model)

summary(model, parameter = "betas")

# plot(model)


}

}
