% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_dlm.R
\name{print.DLM}
\alias{print.DLM}
\title{Print Values for DLM fitted models}
\usage{
\method{print}{DLM}(x, ...)
}
\arguments{
\item{x}{A \code{DLM} or \code{ClosedDLM} object, result of a call to dlm() or dlm_close() function.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A character vector with the details of a fitted \code{DLM} or \code{ClosedDLM} model.
}
\description{
Print details from a fitted \code{DLM} or \code{ClosedDLM} models and returns it invisibly.
}
\examples{
## Importing mortality data from the USA available on the Human Mortality Database (HMD):
data(USA)

## Selecting the log mortality rate of the 2010 male population ranging from 0 to 100 years old
USA2010 = USA[USA$Year == 2010,]
x = 0:100
Ex = USA2010$Ex.Male[x+1]
Dx = USA2010$Dx.Male[x+1]
qx_t = Dx/Ex
qx_t = 1 - exp(-qx_t)
y = log(qx_t)

## Fitting DLM
fit = dlm(y, M = 100, bn = 20, thin = 1)
print(fit)

}
\seealso{
\code{\link[=print.HP]{print.HP()}}, \code{\link[=print.BLC]{print.BLC()}} and \code{\link[=print.PredBLC]{print.PredBLC()}} for \code{HP}, \code{BLC} or \code{PredBLC} methods.
}
