% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cardinalities.R
\name{get_cardinalities}
\alias{get_cardinalities}
\title{Get cardinalities for each distance}
\usage{
get_cardinalities(n_items, metric = c("footrule", "spearman", "ulam"))
}
\arguments{
\item{n_items}{Number of items.}

\item{metric}{Distance function, one of "footrule", "spearman", or "ulam".}
}
\value{
A dataframe with two columns, \code{distance} which contains each distance
in the support set at the current number of items, i.e., \eqn{d_{m}}, and
\code{value} which contains the number of values at this particular distances,
i.e., \eqn{N_{m,n}}.
}
\description{
The partition function for the Mallows model can be defined in a
computationally efficient manner as
\deqn{Z_{n}(\alpha) = \sum_{d_{n} \in
  \mathcal{D}_{n}} N_{m,n} e^{-(\alpha/n) d_{m}}}.
In this equation, \eqn{\mathcal{D}_{n}} a set containing all possible
distances at the given number of items, and \eqn{d_{m}} is on element of
this set. Finally, \eqn{N_{m,n}} is the number of possible configurations
of the items that give the particular distance. See
\insertCite{irurozki2016;textual}{BayesMallows},
\insertCite{vitelli2018;textual}{BayesMallows}, and
\insertCite{crispino2023;textual}{BayesMallows} for details.

For footrule distance, the cardinalities come from entry A062869 in the
On-Line Encyclopedia of Integer Sequences (OEIS)
\insertCite{oeis}{BayesMallows}. For Spearman distance, they come from
entry A175929, and for Ulam distance from entry A126065.
}
\examples{
# Extract the cardinalities for four items with footrule distance
n_items <- 4
dat <- get_cardinalities(n_items)
# Compute the partition function at alpha = 2
alpha <- 2
sum(dat$value * exp(-alpha / n_items * dat$distance))
#'
# We can confirm that it is correct by enumerating all possible combinations
all <- expand.grid(1:4, 1:4, 1:4, 1:4)
perms <- all[apply(all, 1, function(x) length(unique(x)) == 4), ]
sum(apply(perms, 1, function(x) exp(-alpha / n_items * sum(abs(x - 1:4)))))

# We do the same for the Spearman distance
dat <- get_cardinalities(n_items, metric = "spearman")
sum(dat$value * exp(-alpha / n_items * dat$distance))
#'
# We can confirm that it is correct by enumerating all possible combinations
sum(apply(perms, 1, function(x) exp(-alpha / n_items * sum((x - 1:4)^2))))
}
\references{
\insertAllCited{}
}
\seealso{
Other partition function: 
\code{\link{estimate_partition_function}()}
}
\concept{partition function}
