% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{asymptotic_partition_function}
\alias{asymptotic_partition_function}
\title{Asymptotic Approximation of Partition Function}
\usage{
asymptotic_partition_function(
  alpha_vector,
  n_items,
  metric,
  K,
  n_iterations = 1000L,
  tol = 1e-09
)
}
\arguments{
\item{alpha_vector}{A numeric vector of alpha values.}

\item{n_items}{Integer specifying the number of items.}

\item{metric}{One of \code{"footrule"} and \code{"spearman"}.}

\item{K}{Integer.}

\item{n_iterations}{Integer specifying the number of iterations.}

\item{tol}{Stopping criterion for algorithm. The previous matrix is subtracted
from the updated, and if the maximum absolute relative difference is below \code{tol},
the iteration stops.}
}
\value{
A vector, containing the partition function at each value of alpha.
}
\description{
Compute the asymptotic approximation of the logarithm of the partition function,
using the iteration algorithm of \insertCite{mukherjee2016;textual}{BayesMallows}.
}
\references{
\insertAllCited{}
}
\keyword{internal}
