% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_constraints.R
\name{generate_constraints}
\alias{generate_constraints}
\title{Generate Constraint Set from Pairwise Comparisons}
\usage{
generate_constraints(preferences, n_items, cl = NULL)
}
\arguments{
\item{preferences}{Data frame of preferences. For the case of consistent
rankings, \code{preferences} should be returned from \code{\link{generate_transitive_closure}}.
For the case of inconsistent preferences, when using an error model as described
in \insertCite{crispino2018;textual}{BayesMallows}, a dataframe of preferences
can be directly provided.}

\item{n_items}{Integer specifying the number of items.}

\item{cl}{Optional computing cluster used for parallelization, returned
from \code{parallel::makeCluster}. Defaults to \code{NULL}.}
}
\value{
A list which is used internally by the MCMC algorithm.
}
\description{
This function is relevant when \code{\link{compute_mallows}} is called
repeatedly with the same data, e.g., when determining the
number of clusters. It precomputes a list of constraints used
internally by the MCMC algorithm, which otherwise would be
recomputed each time \code{\link{compute_mallows}} is called.
}
\examples{
# Here is an example with the beach preference data.
# First, generate the transitive closure.
beach_tc <- generate_transitive_closure(beach_preferences)

# Next, generate an initial ranking.
beach_init_rank <- generate_initial_ranking(beach_tc)

# Then generate the constrain set used intervally by compute_mallows
constr <- generate_constraints(beach_tc, n_items = 15)

# Provide all these elements to compute_mallows
model_fit <- compute_mallows(rankings = beach_init_rank,
preferences = beach_tc, constraints = constr)

\dontrun{
  # The constraints can also be generated in parallel
  library(parallel)
  cl <- makeCluster(detectCores() - 1)
  constr <- generate_constraints(beach_tc, n_items = 15, cl = cl)
  stopCluster(cl)
}
}
\references{
\insertAllCited{}
}
