% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mra-wendland-2d.R
\name{mra_wendland_2d}
\alias{mra_wendland_2d}
\title{Code to construct the mutli-resolution sparse basis function representation for fitting spatial processes}
\usage{
mra_wendland_2d(
  locs,
  M = 4,
  n_coarse_grid = 10,
  n_padding = 5L,
  n_neighbors = 68,
  use_spam = TRUE
)
}
\arguments{
\item{locs}{The location variables in 2 dimensions over which to construct the basis function representation}

\item{M}{The number of resolutions.}

\item{n_coarse_grid}{The number of basis functions in one direction (e.g. \code{n_coarse_grid = 10} results in a \eqn{10 \times 10}{10x10} course grid which is further extended by the number of additional padding basis functions given by \code{n_padding}.}

\item{n_padding}{The number of additional boundary points to add on each boundary. For example, n_padding = 5 will add 5 boundary knots to the both the left  and right side of the grid).}

\item{n_neighbors}{The expected number of neighbors for each interior basis function. This determines the basis radius parameter.}

\item{use_spam}{is a boolean flag to determine whether the output is a list of \code{spam::spam} matrix objects (\code{use_spam = TRUE}) or a an \eqn{n \times n}{n x n} sparse Matrix of class \code{Matrix::dgCMatrix} \code{use_spam = FALSE} (see spam and Matrix packages for details).}
}
\value{
A list of objects including the MRA knots locations \code{locs_grid},
the Wendland basis representation matrix \code{W} at the observed locations,
the basis radius \code{radius}, the numbers of resolutions \code{M},
the number of expected neighbors in the interior of each grid \code{n_neighbors},
the number of interior basis functions in one direction \code{n_coarse_grid},
the number of additional padding basis functions given by \code{n_padding},
and the setting \code{use_spam} which determines whether the MRA output uses the \code{spam} format.
}
\description{
Code to construct the mutli-resolution sparse basis function representation for fitting spatial processes
}
\examples{
set.seed(111)
locs <- matrix(runif(20), 10, 2)
MRA <- mra_wendland_2d(locs, M = 2, n_coarse_grid = 4)
## plot the MRA grid at different resolutions
layout(matrix(1:2, 1, 2))
plot(MRA$locs_grid[[1]])
plot(MRA$locs_grid[[2]])

}
