% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RJMCMC.R
\name{.J_RJMCMC}
\alias{.J_RJMCMC}
\title{RJMCMC (with Bayesian Borrowing)}
\usage{
.J_RJMCMC(
  df_hist,
  df_curr,
  Y,
  Y_0,
  I,
  I_0,
  X,
  X_0,
  lambda,
  lambda_0,
  beta,
  beta_0,
  mu,
  sigma2,
  tau,
  s,
  J,
  Jmax,
  bp,
  bp_0,
  clam_smooth,
  a_tau = NULL,
  b_tau = NULL,
  c_tau = NULL,
  d_tau = NULL,
  type,
  p_0 = NULL,
  phi,
  pi_b,
  maxSj
)
}
\arguments{
\item{df_hist}{data_frame containing historical data.}

\item{df_curr}{data_frame containing current trial data.}

\item{Y}{data.}

\item{Y_0}{historical data.}

\item{I}{censoring indicator.}

\item{I_0}{historical trial censoring indicator.}

\item{X}{design matrix.}

\item{X_0}{historical trial design matrix.}

\item{lambda}{baseline hazard.}

\item{lambda_0}{historical trial baseline hazard.}

\item{beta}{current trial parameters.}

\item{beta_0}{historical trial parameters.}

\item{mu}{prior mean for baseline hazard.}

\item{sigma2}{prior variance hyperparameter for baseline hazard.}

\item{tau}{borrowing parameter.}

\item{s}{split point locations, J + 2.}

\item{J}{number of split points.}

\item{Jmax}{maximum number of split points.}

\item{bp}{number of covariates in current trial.}

\item{bp_0}{number of covariates in historical trial.}

\item{clam_smooth}{neighbor interactions, in range (0, 1), for ICAR update.}

\item{a_tau}{tau hyperparameter.}

\item{b_tau}{tau hyperparameter.}

\item{c_tau}{tau hyperparameter.}

\item{d_tau}{tau hyperparameter.}

\item{type}{choice of borrowing, "mix", "uni", or any other string for 
borrowing on every baseline hazard without mixture.}

\item{p_0}{mixture ratio.}

\item{phi}{J hyperparameter.}

\item{pi_b}{probability of birth move.}

\item{maxSj}{maximal time point, either current or historic.}
}
\value{
list of proposed J and s, with adjusted values of lambda, lambda_0, 
tau, Sigma_s, and data_frames for historical and current trial data.
}
\description{
Metropolis-Hastings Green Reversible Jump move, with Bayesian 
Borrowing
}
