% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_ermod.R
\name{sim_er_new_exp}
\alias{sim_er_new_exp}
\alias{sim_er_curve}
\title{Simulate from ER model at specified exposure values}
\usage{
sim_er_new_exp(
  ermod,
  exposure_to_sim_vec = NULL,
  data_cov = NULL,
  n_draws_sim = NULL,
  seed_sample_draws = NULL,
  output_type = c("draws", "median_qi"),
  qi_width = 0.95
)

sim_er_curve(
  ermod,
  exposure_range = NULL,
  num_exposures = 51,
  data_cov = NULL,
  n_draws_sim = NULL,
  seed_sample_draws = NULL,
  output_type = c("draws", "median_qi"),
  qi_width = 0.95
)
}
\arguments{
\item{ermod}{An object of class \code{ermod}}

\item{exposure_to_sim_vec}{Vector of exposure values to simulate.}

\item{data_cov}{Data frame containing covariates to use for simulation,
see details below.}

\item{n_draws_sim}{Number of draws for simulation. If NULL (default),
all draws in the model object are used.}

\item{seed_sample_draws}{Seed for sampling draws. Default is NULL.}

\item{output_type}{Type of output. "draws" returns the raw draws from the
simulation, and "median_qi" returns the median and quantile interval.}

\item{qi_width}{Width of the quantile interval. Default is 0.95. Only
used when \code{output_type = "median_qi"}.}

\item{exposure_range}{Range of exposure values to simulate. If NULL
(default), it is set to the range of the exposure variable in the original
data for model development.}

\item{num_exposures}{Number of exposure values to simulate.}
}
\value{
\code{ersim} object, which is a tibble with the simulated responses
with some additional information in object attributes.
It has three types of predictions - \code{.linpred}, \code{.epred}, \code{.prediction}.
\code{.linpred} and \code{.epred} are similar in a way that they both represent
"expected response", i.e. without residual variability. They are the same
for models with continuous endpoits (Emax model). For models with binary
endpoints, \code{.linpred} is the linear predictor (i.e. on the logit scale) and
\code{.epred} is on the probability scale. \code{.prediction} is the predicted
response with residual variability (or in case of binary endpoint,
the predicted yes (1) or no (0) for event occurrence).
See \code{\link[tidybayes:add_predicted_draws]{tidybayes::add_epred_draws()}} for more details.

In case of \code{output_type = "median_qi"}, it returns \code{ersim_med_qi} object.
}
\description{
Simulate from ER model at specified exposure values
}
\details{
Simulation dataset will be all combinations of covariates in \code{data_cov}
and exposure values in \code{exposure_to_sim_vec},
so the run time can become very long if \code{data_cov} has many rows.

\code{data_cov} has to be supplied if \code{ermod} is a model with covariates.
It is recommended that \code{data_cov} contains subject identifiers such as
\code{ID} for post-processing.

Exposure values in \code{data_cov} will be ignored.

\code{\link[=sim_er_curve]{sim_er_curve()}} is a wrapper function for \code{\link[=sim_er_new_exp]{sim_er_new_exp()}}
that use a range of exposure values to simulate the expected responses.
Particularly useful for plotting the exposure-response curve.
}
\examples{
data(d_sim_binom_cov_hgly2)

ermod_bin <- dev_ermod_bin(
  data = d_sim_binom_cov_hgly2,
  var_resp = "AEFLAG",
  var_exposure = "AUCss_1000",
  var_cov = "BHBA1C_5",
)

ersim_new_exp_med_qi <- sim_er_new_exp(
  ermod_bin,
  exposure_to_sim_vec = seq(2, 6, by = 0.2),
  data_cov = dplyr::tibble(BHBA1C_5 = 4:10),
  n_draws_sim = 500, # This is set to make the example run faster
  output_type = "median_qi"
)

ersim_new_exp_med_qi

}
\seealso{
\code{\link[=calc_ersim_med_qi]{calc_ersim_med_qi()}} for calculating median and quantile interval
from \code{ersim} object (generated with \code{output_type = "draws"}).
}
