% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustCpObj.R
\name{posterior_estimate.ClustCpObj}
\alias{posterior_estimate.ClustCpObj}
\title{Estimate the change points of the data}
\usage{
\method{posterior_estimate}{ClustCpObj}(
  object,
  loss = "VI",
  maxNClusters = 0,
  nRuns = 16,
  maxZealousAttempts = 10,
  ...
)
}
\arguments{
\item{object}{an object of class \code{ClustCpObj}.}

\item{loss}{The loss function used to estimate the final partition, it can be "VI", "binder", "omARI", "NVI", "ID", "NID".}

\item{maxNClusters}{maximum number of clusters in salso procedure.}

\item{nRuns}{number of runs in salso procedure.}

\item{maxZealousAttempts}{maximum number of zealous attempts in salso procedure.}

\item{...}{parameter of the generic method.}
}
\value{
The function returns a vector with the cluster assignment of each observation.
}
\description{
The \code{posterior_estimate} method estimates the change points of the data making use of the salso algorithm, for a \code{DetectCPObj} class object.
}
\details{
put details here
}
\examples{

data_mat <- matrix(NA, nrow = 5, ncol = 100)

data_mat[1,] <- as.numeric(c(rnorm(50,0,0.100), rnorm(50,1,0.250)))
data_mat[2,] <- as.numeric(c(rnorm(50,0,0.125), rnorm(50,1,0.225)))
data_mat[3,] <- as.numeric(c(rnorm(50,0,0.175), rnorm(50,1,0.280)))
data_mat[4,] <- as.numeric(c(rnorm(25,0,0.135), rnorm(75,1,0.225)))
data_mat[5,] <- as.numeric(c(rnorm(25,0,0.155), rnorm(75,1,0.280)))

out <- clust_cp(data = data_mat, n_iterations = 5000, n_burnin = 1000,
                params = list(L = 1, B = 1000, phi = 0.5), kernel = "ts")

posterior_estimate(out)

}
\references{
#' D. B. Dahl, D. J. Johnson, and P. Müller (2022), Search Algorithms and Loss
Functions for Bayesian Clustering, \emph{Journal of Computational and
Graphical Statistics}, 31(4), 1189-1201, \doi{10.1080/10618600.2022.2069779}.
}
