% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/clusterFunctionsInteractive.R
\name{makeClusterFunctionsInteractive}
\alias{makeClusterFunctionsInteractive}
\title{Create cluster functions for sequential execution in same session.}
\usage{
makeClusterFunctionsInteractive(write.logs = TRUE)
}
\arguments{
\item{write.logs}{[\code{logical(1)}]\cr
Sink the output to log files. Turning logging off can increase the speed of
calculations but makes it next to impossible to debug.
Default is \code{TRUE}.}
}
\value{
[\code{\link{ClusterFunctions}}].
}
\description{
All jobs executed under these cluster functions are executed
sequentially, in the same interactive R process that you currently are.
That is, \code{submitJob} does not return until the
job has finished. The main use of this \code{ClusterFunctions}
implementation is to test and debug programs on a local computer.

Listing jobs returns an empty vector (as no jobs can be running when you call this)
and \code{killJob} returns at once (for the same reason).
}
\seealso{
Other clusterFunctions: \code{\link{ClusterFunctions}},
  \code{\link{makeClusterFunctions}};
  \code{\link{makeClusterFunctionsLSF}};
  \code{\link{makeClusterFunctionsLocal}};
  \code{\link{makeClusterFunctionsMulticore}};
  \code{\link{makeClusterFunctionsSGE}};
  \code{\link{makeClusterFunctionsSLURM}};
  \code{\link{makeClusterFunctionsSSH}};
  \code{\link{makeClusterFunctionsTorque}}
}

