% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BallMapper.R
\name{ColorIgraphPlot}
\alias{ColorIgraphPlot}
\title{Produce a static color visualization of the Ball Mapper graph. It is based on the output from BallMapper function.}
\usage{
ColorIgraphPlot(outputFromBallMapper, showVertexLabels = TRUE,
  showLegend = FALSE, minimal_ball_radius = 7,
  maximal_ball_scale = 20, maximal_color_scale = 10)
}
\arguments{
\item{outputFromBallMapper, }{an output from the BallMapper function}

\item{showVertexLabels, }{a boolean value determining if the vertex labels are to be shown (TRUE by default).}

\item{showLegend, }{a boolean value determining if the legend is to be shown (FALSE by default).}

\item{minimal_ball_radius, }{provide a minimal value of the radius of balls used in visualization (7 by default).}

\item{maximal_ball_scale, }{provide a maximal value of the radius of balls used in visualization (20 by default).}

\item{maximal_color_scale, }{Provide a maximal value (starting from 0) of the color of a ball (10 by default).}
}
\value{
None
}
\description{
Produce a static color visualization of the Ball Mapper graph. It is based on the output from BallMapper function.
}
\examples{
var <- seq(from=0,to=6.3,by=0.1)
points <- as.data.frame( cbind( sin(var),cos(var) ) )
values <- as.data.frame( sin(var) )
epsilon <- 0.25
l <- BallMapper(points,values,epsilon)
ColorIgraphPlot(l)
}
