% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\docType{methods}
\name{growLin}
\alias{growLin}
\alias{growLin,Organism-method}
\title{Function for letting organisms grow linearly}
\usage{
growLin(object, biomass, fbasol, tstep)

\S4method{growLin}{Organism}(object, biomass, fbasol, tstep)
}
\arguments{
\item{object}{An object of class Organisms.}

\item{biomass}{A number indicating the current biomass, which has to be updated.}

\item{fbasol}{Problem object according to the constraints and then solved with \code{optimizeProb}.}

\item{tstep}{A number giving the time intervals for each simulation step.}
}
\value{
Returns the updated biomass of the organisms of interest.
}
\description{
The generic function \code{growLin} implements a growth model of organisms in their environment.
}
\details{
Linear growth of organisms is implemented by adding the calculated growthrate by \code{optimizeLP} to the already present growth value.
}
\seealso{
\code{\link{Organism-class}} and \code{\link{optimizeLP}}
}
