% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/class_definitions.R
\docType{class}
\name{hiddenDiffusion-class}
\alias{hiddenDiffusion-class}
\title{S4 class of model informations for hidden diffusion process}
\description{
Informations of model
  \eqn{Z_i = Y_{t_i} + \epsilon_i, dY_t = b(\phi,t,Y_t)dt + \gamma \widetilde{s}(t,Y_t)dW_t,
  \epsilon_i\sim N(0,\sigma^2), Y_{t_0}=y_0(\phi, t_0)}.
}
\section{Slots}{

\describe{
\item{\code{phi}}{parameter \eqn{\phi}}

\item{\code{gamma2}}{parameter \eqn{\gamma^2}}

\item{\code{sigma2}}{parameter \eqn{\sigma^2}}

\item{\code{y0.fun}}{function \eqn{y_0(\phi, t)}}

\item{\code{b.fun}}{function \eqn{b(\phi,t,y)}}

\item{\code{sT.fun}}{function \eqn{\widetilde{s}(t,y)}}

\item{\code{prior}}{list of prior parameters}

\item{\code{start}}{list of starting values for the Metropolis within Gibbs sampler}
}}
\examples{
parameter <- list(phi = c(2, 1), gamma2 = 0.1, sigma2 = 0.1)
b.fun <- function(phi, t, y) phi[1] * y
sT.fun <- function(t, y) y
y0.fun <- function(phi, t) phi[2]
start <- parameter
prior <- list(m.phi = parameter$phi, v.phi = parameter$phi^2, alpha.gamma = 3,
   beta.gamma = parameter$gamma2*2, alpha.sigma=3, beta.sigma=parameter$sigma2*2)
model <- set.to.class("hiddenDiffusion", parameter, prior, start,
  b.fun = b.fun, sT.fun = sT.fun, y0.fun = y0.fun)
}

