% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/64_irf_method.R, R/65_irf_print.R
\name{irf.bvar}
\alias{irf.bvar}
\alias{fevd.bvar}
\alias{irf}
\alias{irf<-}
\alias{fevd}
\alias{summary.bvar_irf}
\title{Impulse response and forecast error methods for Bayesian VARs}
\usage{
\method{irf}{bvar}(x, ..., conf_bands, n_thin = 1L)

\method{fevd}{bvar}(x, ..., conf_bands, n_thin = 1L)

irf(x, ...)

irf(x) <- value

fevd(x, ...)

\method{summary}{bvar_irf}(object, vars_impulse = NULL, vars_response = NULL, ...)
}
\arguments{
\item{x, object}{A \code{bvar} object, obtained from \code{\link{bvar}}.
Summary and print methods take in a \code{bvar_irf} / \code{bvar_fevd}
object.}

\item{...}{A \code{bv_irf} object or arguments to be fed into
\code{\link{bv_irf}}. Contains settings for the IRFs / FEVDs.}

\item{conf_bands}{Numeric vector of confidence bands to apply.
E.g. for bands at 5\%, 10\%, 90\% and 95\% set this to \code{c(0.05, 0.1)}.
Note that the median, i.e. 0.5 is always included.}

\item{n_thin}{Integer scalar. Every \emph{n_thin}'th draw in \emph{x} is used
to calculate, others are dropped.}

\item{value}{A \code{bvar_irf} object to assign.}

\item{vars_impulse, vars_response}{Optional numeric or character vector.
Used to subset the summary method's outputs to certain variables by position
or name (must be available). Defaults to \code{NULL}, i.e. all variables.}
}
\value{
Returns a list of class \code{bvar_irf} including IRFs and optionally
FEVDs at desired confidence bands. The \code{fevd} method only returns a
the nested \code{bvar_fevd} object.
The summary method returns a numeric array of impulse responses at the
specified confidence bands.
}
\description{
Retrieves / calculates impulse response functions (IRFs) and/or forecast
error variance decompositions (FEVDs) for Bayesian VARs generated via
\code{\link{bvar}}. If the object is already present and no settings are
supplied it is simply retrieved, otherwise it will be calculated ex-post.
Note that FEVDs require the presence / calculation of IRFs.
To store the results you may want to assign the output using the setter
function (\code{irf(x) <- irf(x)}). May also be used to update
confidence bands.
}
\examples{
\donttest{
# Access a subset of the fred_qd dataset
data <- fred_qd[, c("CPIAUCSL", "UNRATE", "FEDFUNDS")]
# Transform it to be stationary
data <- fred_transform(data, codes = c(5, 5, 1), lag = 4)

# Estimate a BVAR using one lag, default settings and very few draws
x <- bvar(data, lags = 1, n_draw = 1000L, n_burn = 200L, verbose = FALSE)

# Calculate and store structural IRFs (via Cholesky decomposition)
irf(x) <- irf(x, identification = TRUE)

# Update the confidence bands of the IRFs
irf(x, conf_bands = c(0.01, 0.05, 0.1))

# Compute and store with a longer horizon, no identification and thinning
irf(x) <- irf(x, bv_irf(horizon = 24L, identification = FALSE), n_thin = 10L)

# Recalculate with sign restrictions provided via the ellipsis
irf(x, sign_restr = matrix(c(1, NA, NA, -1, 1, -1, -1, 1, 1), nrow = 3))

# Calculate the forecast error variance decomposition
fevd(x)

# Get a summary of the saved impulse response function
summary(x)

# Limit the summary to responses of variable #2
summary(x, vars_response = 2L)
}
}
\seealso{
\code{\link{plot.bvar_irf}}; \code{\link{bv_irf}}
}
\keyword{BVAR}
\keyword{analysis}
\keyword{fevd}
\keyword{irf}
