% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/80_coda.R
\name{as.mcmc.bvar}
\alias{as.mcmc.bvar}
\title{Method for coda Markov chain Monte Carlo objects}
\usage{
as.mcmc.bvar(
  x,
  vars = NULL,
  vars_response = NULL,
  vars_impulse = NULL,
  chains = list(),
  ...
)
}
\arguments{
\item{x}{A \code{bvar} object, obtained from \code{\link{bvar}}.}

\item{vars}{Optional character vector used to subset the converted
hyperparameters. The elements need to match the names of hyperparameters
(plus \code{"ml"}). Defaults to \code{NULL}, i.e. all variables.}

\item{vars_response, vars_impulse}{Optional integer vector with the
positions of coefficient values to convert. \emph{vars_response} corresponds
to a specific dependent variable, \emph{vars_impulse} to an independent one.
Note that the constant is found at position one.}

\item{chains}{List with additional \code{bvar} objects. If provided, contents
are converted to an object of class \code{\link[coda]{mcmc.list}}.}

\item{...}{Other parameters for \code{\link[coda]{as.mcmc}} and
\code{\link[coda]{as.mcmc.list}}.}
}
\description{
Method to convert chains of hyperparameters and marginal likelihoods obtained
from \code{\link{bvar}} or coefficent values to objects compatible for
further processing with \pkg{coda}, i.e., objects of class
\code{\link[coda]{mcmc}} or \code{\link[coda]{mcmc.list}}.
Multiple chains, that is comparable \code{bvar} objects may be converted
using the \emph{chains} argument.
}
\examples{
\donttest{
library("coda")

data <- matrix(rnorm(200), ncol = 2)
x <- bvar(data, lags = 2)
y <- bvar(data, lags = 2)

# Convert hyperparameter lambda and the marginal likelihood
as.mcmc(x, vars = c("ml", "lambda"))

# Add second chain for further processing
as.mcmc(x, vars = c("ml", "lambda"), chains = list(y = y))
}
}
\seealso{
\code{\link{bvar}}; \code{\link[coda]{mcmc}}
}
\keyword{BVAR}
\keyword{VAR}
\keyword{coda}
\keyword{convergence}
\keyword{mcmc}
