% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/80_plot.R
\name{plot.bvar}
\alias{plot.bvar}
\alias{bv_plot}
\title{Hyperparameter plot}
\usage{
\method{plot}{bvar}(x, mar = c(2, 2, 2, 0.5), ...)

bv_plot(x, mar = c(2, 2, 2, 0.5), ...)
}
\arguments{
\item{x}{A \code{bvar}, obtained from \code{\link{bvar}}.}

\item{mar}{Numeric vector. Margins for \code{\link[graphics]{par}}.}

\item{...}{Other graphical parameters for \code{\link[graphics]{par}}.}
}
\description{
A collection of diagnostic plots with traces and densities of the marginal
posterior likelihood and available hyperparameters. Minimum and maximum
values of the hyperparameters are plotted as dashed lines in "darkgray".
}
\examples{
\donttest{
data <- matrix(rnorm(200), ncol = 2)
x <- bvar(data, lags = 2)

# Plot various output generated
plot(x)
}
}
\seealso{
\code{\link{bv_plot_trace}}; \code{\link{bv_plot_irf}}
}
