#' Bias and Uncertainty Corrected Sample Size (BUCSS)
#'
#' Bias- and Uncertainty-Corrected Sample Size. BUCSS implements a method of correcting for publication bias and uncertainty when planning sample sizes in a future study from an original study
#'
#' Note that \url{https://designingexperiments.com} uses Shiny R apps that implement, via a web interface, the functions contained in BUCSS.
#'
#' @references Anderson, S. & Kelley, K., Maxwell, S. E. (2017). Sample size planning for more accurate statistical power: A method correcting sample effect sizes for uncertainty and publication bias. \emph{Psychological Science}, \emph{28}, 1547--1562.
#'
#' See \url{https://designingexperiments.com/} for Shiny R implementation of the functions.
#'
#' For suggested updates, please email Samantha Anderson \email{samantha.f.anderson@asu.edu} or Ken Kelley \email{kkelley@nd.edu}.
#' @author Samantha Anderson \email{samantha.f.anderson@asu.edu} and Ken Kelley \email{kkelley@nd.edu}
#'
"_PACKAGE"
