% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dc.R
\name{dc.InputCheck}
\alias{dc.InputCheck}
\title{Check the inputs to functions that use this common pattern}
\usage{
dc.InputCheck(params, func, printnames = c("r", "alpha", "s", "beta"), ...)
}
\arguments{
\item{params}{If used by \code{pnbd.[...]} functions, Pareto/NBD parameters
-- a vector with r, alpha, s, and beta, in that order. See
\code{\link{pnbd.LL}}. If used by \code{bgnbd.[...]} functions, BG/NBD
parameters -- a vector with r, alpha, a, and b, in that order. See
\code{\link{bgnbd.LL}}. If used by \code{bgbb.[...]} functions, BG/BB
parameters -- a vector with alpha, beta, gamma, and delta, in that order.
See \code{\link{bgbb.LL}}. If used by \code{spend.[...]} functions, a
vector of gamma-gamma parameters -- p, q, and gamma, in that order. See
\code{\link{spend.LL}}.}

\item{func}{Function calling dc.InputCheck}

\item{printnames}{a string vector with the names of parameters to pass to
\code{\link{dc.check.model.params}}}

\item{...}{other arguments}
}
\value{
If all is well, a data frame with everything you need in it, with
nrow() equal to the length of the longest vector in \code{...}
}
\description{
A bunch of functions whose names start with \code{pnbd} take a set of four
parameters as their first argument, and then a set of vectors or scalars such
as \code{x} or \code{T.cal} as their subsequent arguments. This function
started out as pnbd.InputCheck() and it was meant to run input checks for any
number of such subsequent vector arguments, as long as they all met the same
requirements as \code{x}, \code{t.x} and \code{T.cal} in
\code{\link{pnbd.LL}}: meaning, the length of the longest of these vectors is
a multiple of the lengths of all others, and all vectors are numeric and
positive.
}
\details{
With an extra argument, \code{printnames}, pnbd.InputCheck() could also
accommodate input checks for functions whose names start with \code{bgbb},
\code{bgnbd}, and \code{spend} so it was basically useful everywhere. That's
when it became \code{dc.InputCheck()}. \code{params} can have any length as
long as that length is the same as the length of \code{printnames}, so
\code{dc.InputCheck()} can probably handle mixtures of distributions for
modeling BTYD behavior that are not yet implemented.

By other arguments ... here we mean a bunch of named vectors that are used by
functions that call \code{dc.InputCheck}, such as x, t.x, T.cal, etc. The
standard rules for vector operations apply - if they are not of the same
length, shorter vectors will be recycled (start over at the first element)
until they are as long as the longest vector. Vector recycling is a good way
to get into trouble. Keep vectors to the same length and use single values
for parameters that are to be the same for all calculations. If one of these
parameters has a length greater than one, the output will be a vector of
probabilities.
}
\seealso{
\code{\link{pnbd.LL}}
\code{\link{pnbd.ConditionalExpectedTransactions}}
}
