% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Saving}
\alias{Saving}
\title{Problem asset ration for savings and loan companies in California, New York,
and Texas}
\format{
A data frame/tibble with 65 observations on two variables
\describe{ 
\item{par}{problem-asset-ratio for Savings & Loans that were listed as being financially troubled in 1992} 
\item{state}{U.S. state}
 }
}
\usage{
Saving
}
\description{
Data for Exercise 10.34 and 10.49
}
\examples{

boxplot(par ~ state, data = Saving, col = "red")
boxplot(par ~ state, data = Saving, log = "y", col = "red")
model <- aov(par ~ state, data = Saving)
summary(model)
plot(TukeyHSD(model))
kruskal.test(par ~ factor(state), data = Saving)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
