% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Cancer}
\alias{Cancer}
\title{Survival times of terminal cancer patients treated with vitamin C}
\format{A data frame/tibble with 64 observations on two variables
\describe{ 
\item{survival}{survival time (in days) of terminal patients 
treated with vitamin C}
\item{type}{a factor indicating type of cancer with levels 
\code{breast}, \code{bronchus}, \code{colon}, \code{ovary}, and 
\code{stomach}} 
}}
\source{
Cameron, E and Pauling, L. 1978. \dQuote{Supplemental Ascorbate in the 
Supportive Treatment of Cancer.} \emph{Proceedings of the National Academy of 
Science}, 75, 4538-4542.
}
\usage{
Cancer
}
\description{
Data for Exercises 6.55 and 6.64
}
\examples{

boxplot(survival ~ type, Cancer, col = "blue")
stomach <- Cancer$survival[Cancer$type == "stomach"]
bronchus <- Cancer$survival[Cancer$type == "bronchus"]
boxplot(stomach, ylab = "Days")
SIGN.test(stomach, md = 100, alternative = "greater")
SIGN.test(bronchus, md = 100, alternative = "greater")
rm(bronchus, stomach)


}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
