\name{Homes}
\alias{Homes}
\docType{data}
\title{Median prices of single-family homes in 65 metropolitan statistical areas}
\description{
  Data for Statistical Insight Chapter 5
}
\usage{Homes}
\format{
  A data frame with 65 observations on the following 5 variables.
  \describe{
    \item{\code{City}}{a factor with levels \code{Akron OH} \code{Albuquerque NM} \code{Anaheim CA} \code{Atlanta GA} \code{Baltimore MD} \code{Baton Rouge LA} \code{Birmingham AL} \code{Boston MA} \code{Bradenton FL} \code{Buffalo, NY} \code{Charleston, SC} \code{Chicago, IL} \code{Cincinnati, OH} \code{Cleveland, OH} \code{Columbia, SC} \code{Columbus, OH} \code{Corpus Christi, TX} \code{Dallas, TX} \code{Daytona Beach, FL} \code{Denver, CO} \code{Des Moines, IA} \code{Detroit, MI} \code{El Paso, TX} \code{Grand Rapids, MI} \code{Hartford, CT} \code{Honolulu, HI} \code{Houston, TX} \code{Indianapolis, IN} \code{Jacksonville, FL} \code{Kansas City, MO} \code{Knoxville, TN} \code{Las Vegas, NV} \code{Los Angeles, CA} \code{Louisville, KY} \code{Madison, WI} \code{Memphis, TN} \code{Miami, FL} \code{Milwaukee, WI} \code{Minneapolis, MN} \code{Mobile, AL} \code{Nashville, TN} \code{New Haven, CT} \code{New Orleans, LA} \code{New York, NY} \code{Oklahoma City, OK} \code{Omaha, NE} \code{Orlando, FL} \code{Philadelphia, PA} \code{Phoenix, AZ} \code{Pittsburgh, PA} \code{Portland, OR} \code{Providence, RI} \code{Sacramento, CA} \code{Salt Lake City, Ut} \code{San Antonio, TX} \code{San Diego, CA} \code{San Francisco, CA} \code{Seattle, WA} \code{Spokane, WA} \code{St Louis, MO} \code{Syracuse,NY} \code{Tampa, FL} \code{Toledo, OH} \code{Tulsa, OK} \code{Washington, DC}}
    \item{\code{X1994}}{a numeric vector}
    \item{\code{Region}}{a factor with levels \code{Midwest} \code{Northeast} \code{South} \code{West}}
    \item{\code{X2000}}{a numeric vector}
    \item{\code{difference}}{a numeric vector}
  }
}
\source{Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}. Duxbury}

\examples{
str(Homes)
attach(Homes)
EDA(X2000)
boxplot(X1994,X2000,names=c("1994","2000"),col=c("red","blue"),ylab="Cost")
boxplot(X2000~Region)
detach(Homes)
}
\keyword{datasets}
