% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_functions.R
\name{run_gender_mcmc}
\alias{run_gender_mcmc}
\title{Run the BSBT with Gender Effect MCMC algorithm}
\usage{
run_gender_mcmc(
  n.iter,
  delta,
  covariance.matrix,
  male.win.matrix,
  female.win.matrix,
  f.initial,
  g.initial,
  omega = 0.1,
  chi = 0.1,
  thinning = 1
)
}
\arguments{
\item{n.iter}{The number of iterations to be run}

\item{delta}{The underrlaxed tuning parameter. Must be in (0, 1)}

\item{covariance.matrix}{The output from the covariance matrix function, which contains the decomposed and inverted covariance matrix. The variance hyperparameter must be set to 1.}

\item{male.win.matrix}{A matrix, where w_ij give the number of times area i beat j when judged by men}

\item{female.win.matrix}{A matrix, where w_ij give the number of times area i beat j when judged by women}

\item{f.initial}{A vector of the initial estimate for f, the grand mean of men and women's perceptions}

\item{g.initial}{A vector of the initial estimate for g, the difference between men and women's perceptions}

\item{omega}{The value of the inverse gamma shape parameter}

\item{chi}{The value of the inverse gamma scale parameter}

\item{thinning}{Setting thinning to i will store every i^th iteration. This may be required for very long runs.}
}
\value{
A list of MCMC output
\itemize{
\item f.matrix - A matrix containing the each iteration of f
\item g.matrix - A matrix containing the each iteration of g
\item alpha.sq - A matrix containing the iterations of alpha^2
\item acceptance.rate - The acceptance rate for f and g
\item time.taken - Time taken to run the MCMC algorithm in seconds
}
}
\description{
This function runs the BSBT MCMC algorithm where the male and female judges can be separated. It generates samples for the grand mean of the male and female perceptions for the derivation in each area and the difference between them. It is similar to \code{\link{run_mcmc}}.
This function requires the data to be separate into two parts, one for each gender. There should be a win matrix for the male judges, and a win matrix for the female judges. Similarly, initial estimates for the grand mean and difference parameters need to be included seperately.
}
\examples{

n.iter <- 10
delta <- 0.1
covariance.matrix <- list()
covariance.matrix$mean <- c(0, 0, 0)
covariance.matrix$decomp <- diag(3)
covariance.matrix$inv    <- diag(3)
men.comparisons <- data.frame("winner" = c(1, 3, 2, 2), "loser" = c(3, 1, 1, 3))
women.comparisons <- data.frame("winner" = c(1, 2, 1, 2), "loser" = c(3, 1, 3, 3))
men.win.matrix <- comparisons_to_matrix(3, men.comparisons) #win matrix for the male judges
women.win.matrix <- comparisons_to_matrix(3, women.comparisons) #win matrix for the female judges
f.initial <- c(0, 0, 0) #initial estimate for grand mean
g.initial <- c(0, 0, 0) #initial estimate for differences

mcmc.output <- run_gender_mcmc(n.iter, delta, covariance.matrix, men.win.matrix,
    women.win.matrix, f.initial, g.initial)

}
