% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dat_mult_trials_exp_covar.R
\name{sim_dat_mult_trials_exp_covar}
\alias{sim_dat_mult_trials_exp_covar}
\title{Simulate data from multiple two-arm trials with an exponentially distributed time-to-event endpoint and one predictor of the intercurrent event}
\usage{
sim_dat_mult_trials_exp_covar(n_iter, params)
}
\arguments{
\item{n_iter}{Positive integer value, number of trials to be simulated.}

\item{params}{List of data parameters as used in \code{sim_dat_one_trial_exp_covar}.}
}
\value{
A list of length \code{n_iter}, containing objects of class \code{tibble()}, each containing one simulated trial dataset.
}
\description{
Simulate data from multiple two-arm trials with an exponentially distributed time-to-event endpoint and one predictor of the intercurrent event
}
\examples{
d_params_covar <- list(
  n = 1000,        
  nt = 500,       
  prob_X1 = 0.4, 
  prob_ice_X1 = 0.5, 
  prob_ice_X0 = 0.2,
  fu_max = 48*7,       
  T0T_rate = 0.2,     
  T0N_rate = 0.2,     
  T1T_rate = 0.15,     
  T1N_rate = 0.1
 )
dat_mult_trials <- sim_dat_mult_trials_exp_covar(
  n_iter = 3,
  params = d_params_covar 
)
lapply(dat_mult_trials, dim)
head(dat_mult_trials[[1]]) 

}
\seealso{
\code{\link[=sim_dat_mult_trials_exp_nocovar]{sim_dat_mult_trials_exp_nocovar()}}
}
