% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmhyb.r
\name{ComputeLikelihood}
\alias{ComputeLikelihood}
\title{Compute the likelihood for a set of parameters}
\usage{
ComputeLikelihood(parameters, phy.graph, traits, measurement.error = 0,
  gamma = 0.5, do.Higham.correction = FALSE,
  do.Brissette.correction = FALSE, do.DE.correction = FALSE)
}
\arguments{
\item{parameters}{Named vector of parameter values; expected names are sigma.sq, mu, SE, bt, and vh}

\item{phy.graph}{An ape::evonet object (a phylogeny stored in phylo format that also includes a reticulation matrix)}

\item{traits}{A vector of trait values, with names equal to the names of taxa on the phylogeny}

\item{measurement.error}{How much uncertainty there is in tip values; a single number is applied to all taxa, a vector is applied to the corresponding taxa}

\item{gamma}{In a hybridization event, what proportion of the trait comes from the donating parent. 0.5 means half comes from each parent}

\item{do.Higham.correction}{Variance-covariance matrices for this model are sometimes poorly conditioned; this is a hack to reduce the impact of that}

\item{do.Brissette.correction}{Applies method of Brissette et al. 2007 to also try to fix matrix condition}

\item{do.DE.correction}{Inspired by Mishra, Sudhanshu K. "The nearest correlation matrix problem: Solution by differential evolution method of global optimization." (2007)}
}
\value{
Returns the negative log likelihood
}
\description{
Computes likelihood for a given network, set of traits, and parameters.
}
\details{
This takes an ape::evonet object. If all you have is a tree (an ape::phylo object), you can use CreateHybridlessEvonet() to convert the tree to an evonet object. You can then use the AddHybridization() function to add hybrid events to this object. Note that networks created in this way can, by chance, result in orders of nodes in the internal edge matrix that cause ape's reorder.phylo function to crash, which is called in many of the plot and write functions. You can still use the plot functions in this package, however.
}
