% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeGrid.r
\name{OB2Polygon}
\alias{OB2Polygon}
\title{Create the polygon for the study area from a data set of class \sQuote{OrganizedBirds}}
\usage{
OB2Polygon(x, shape = "bBox")
}
\arguments{
\item{x}{an object of class \sQuote{OrganizedBirds}, \sQuote{sf} or \sQuote{SpatialPointsDataFrame}}

\item{shape}{which type of polygon should be made from the data:
\itemize{
  \item a bounding box (\dQuote{bBox} or \dQuote{bounding box}; i.e. the smallest bounding rectangle
  that contains all points),
  \item a convex hull (\dQuote{cHull} or \dQuote{convex hull}; i.e. the smallest
  convex set that contains all the points).
  \item the minimum circle (\dQuote{minCircle} or \dQuote{min circle}; i.e. the smallest
  circle that covers all the points).
}}
}
\value{
an object of class \sQuote{sf} with a polygon with geodesic coordinates
 in WGS84 (ESPG:4326).
}
\description{
Create the polygon for the study area from a data set of class \sQuote{OrganizedBirds}
}
\examples{
\donttest{
  ob <- organizeBirds(bombusObs)
  polygon <- OB2Polygon(ob, shape = "cHull")
}
}
