% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_occurrence_country}
\alias{BIEN_occurrence_country}
\title{Extract species occurrence records by country.}
\usage{
BIEN_occurrence_country(
  country = NULL,
  country.code = NULL,
  cultivated = FALSE,
  new.world = NULL,
  all.taxonomy = FALSE,
  native.status = FALSE,
  natives.only = TRUE,
  observation.type = FALSE,
  political.boundaries = FALSE,
  collection.info = FALSE,
  ...
)
}
\arguments{
\item{country}{A single country or a vector of country.}

\item{country.code}{A single country code or a vector of country codes equal in length to the vector of states/province codes.}

\item{cultivated}{Return known cultivated records as well?  Default is FALSE.}

\item{new.world}{NULL (The default) returns global records, TRUE returns only New World, and FALSE only Old World.}

\item{all.taxonomy}{Return all taxonomic information?  This includes the raw data as well as the "scrubbed" data.}

\item{native.status}{Return information on introduction status?  The default value is FALSE. A value of TRUE also returns additional information on introduction status.}

\item{natives.only}{Exclude detected introduced species?  Default is TRUE.}

\item{observation.type}{Return information on type of observation (i.e. specimen vs. plot)?  The default value is FALSE.}

\item{political.boundaries}{Return information on political boundaries for an observation? The default value is FALSE.}

\item{collection.info}{Return additional information about collection and identification? The default value is FALSE.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Dataframe containing occurrence records for the specified country.
}
\description{
BIEN_occurrence_country extracts occurrences records for the specified country/countries.
}
\note{
US FIA coordinates have been fuzzed and swapped, for more details see: https://www.fia.fs.fed.us/tools-data/spatial/Policy/index.php

Political division (or political division code) spelling needs to be exact and case-sensitive, see \code{\link{BIEN_metadata_list_political_names}} for a list of political divisions and associated codes.
}
\examples{
\dontrun{
BIEN_occurrence_country("Cuba")
country_vector<-c("Cuba","Bahamas")
BIEN_occurrence_country(country_vector)}
}
\seealso{
Other occurrence functions: 
\code{\link{BIEN_occurrence_box}()},
\code{\link{BIEN_occurrence_county}()},
\code{\link{BIEN_occurrence_family}()},
\code{\link{BIEN_occurrence_genus}()},
\code{\link{BIEN_occurrence_records_per_species}()},
\code{\link{BIEN_occurrence_spatialpolygons}()},
\code{\link{BIEN_occurrence_species}()},
\code{\link{BIEN_occurrence_state}()}
}
\concept{occurrence functions}
