% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.ggm_compare_estimate.R
\name{select.ggm_compare_estimate}
\alias{select.ggm_compare_estimate}
\title{Graph Selection for \code{ggm_compare_estimate} Objects}
\usage{
\method{select}{ggm_compare_estimate}(object, cred = 0.95, ...)
}
\arguments{
\item{object}{An object of class \code{estimate.default}.}

\item{cred}{Numeric. The credible interval width for selecting the graph
(defaults to 0.95; must be between 0 and 1).}

\item{...}{not currently used}
}
\value{
The returned object of class \code{select.ggm_compare_estimate} contains a lot of information that
        is used for printing and plotting the results. For users of \strong{BGGM}, the following
        are the useful objects:


\itemize{

\item \code{mean_diff} A list of matrices for each group comparsion (partial correlation differences).

\item \code{pcor_adj} A list of weighted adjacency matrices for each group comparsion.

\item \code{adj} A list of adjacency matrices for each group comparsion.

}
}
\description{
Provides the selected graph (of differences) based on credible intervals for
the partial correlations that did not contain zero
\insertCite{Williams2019}{BGGM}.
}
\examples{
\donttest{
# note: iter = 250 for demonstrative purposes
##################
### example 1: ###
##################
# data
Y <- bfi

# males and females
Ymale <- subset(Y, gender == 1,
               select = -c(gender,
                           education))

Yfemale <- subset(Y, gender == 2,
                  select = -c(gender,
                              education))

# fit model
fit <- ggm_compare_estimate(Ymale, Yfemale,
                           type = "continuous",
                           iter = 250,
                           progress = FALSE)


E <- select(fit)

}
}
