% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beidsModule.R
\name{beidsServer}
\alias{beidsServer}
\alias{beidsUI}
\title{Shiny module for searching BEIDs}
\usage{
beidsServer(
  id,
  toGene = TRUE,
  multiple = FALSE,
  beOfInt = NULL,
  selectBe = TRUE,
  orgOfInt = NULL,
  selectOrg = TRUE,
  tableHeight = 150
)

beidsUI(id)
}
\arguments{
\item{id}{an identifier for the module instance}

\item{toGene}{focus on gene entities (default=TRUE): matches from other
BE are converted to genes.}

\item{multiple}{allow multiple selections (default=FALSE)}

\item{beOfInt}{if toGene==FALSE, BE to consider (default=NULL ==> all)}

\item{selectBe}{if toGene==FALSE, display an interface for selecting BE}

\item{orgOfInt}{organism to consider (default=NULL ==> all)}

\item{selectOrg}{display an interface for selecting organisms}

\item{tableHeight}{height of the result table (default: 150)}
}
\value{
A reactive data.frame with the following columns:
\itemize{
\item \strong{beid}: the BE identifier
\item \strong{preferred}: preferred identifier for the same BE in the same scope
\item \strong{be}: the type of biological entity
\item \strong{source}: the source of the identifier
\item \strong{organism}: the BE organism
\item \strong{entity}:  internal identifier of the BE
\item \strong{match}: the matching character string
}
}
\description{
Shiny module for searching BEIDs
}
\section{Functions}{
\itemize{
\item \code{beidsUI}: 
}}

\examples{
\dontrun{
library(shiny)
library(BED)
library(DT)

ui <- fluidPage(
   beidsUI("be"),
   fluidRow(
      column(
         12,
         tags$br(),
         h3("Selected gene entities"),
         DTOutput("result")
      )
   )
)

server <- function(input, output){
   found <- beidsServer("be", toGene=TRUE, multiple=TRUE, tableHeight=250)
   output$result <- renderDT({
      req(found())
      toRet <- found()
      datatable(toRet, rownames=FALSE)
   })
}

shinyApp(ui = ui, server = server)
}

}
