% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbinomBCD.R
\name{dbinomBCD}
\alias{dbinomBCD}
\title{Joint Probability Mass Function for a Bivariate Binomial Distribution via Conditional Specification}
\usage{
dbinomBCD(x, y, n1, n2, p1, p2, lambda)
}
\arguments{
\item{x}{value of \eqn{ X }, must be in \eqn{\{0, 1, ..., n_1\}}}

\item{y}{value of \eqn{ Y }, must be in \eqn{\{0, 1, ..., n_2\}}}

\item{n1}{number of trials for \eqn{ X }, must be non-negative}

\item{n2}{number of trials for \eqn{ Y }, must be non-negative}

\item{p1}{base success probability for \eqn{ X }, in \eqn{(0, 1)}}

\item{p2}{base success probability for \eqn{ Y }, in \eqn{(0, 1)}}

\item{lambda}{dependence parameter, must be positive.}
}
\value{
The probability \eqn{ P(X = x, Y = y)}.
}
\description{
Computes the probability mass function (p.m.f.) of the bivariate binomial conditionals distribution (BBCD) as defined by Ghosh, Marques, and Chakraborty (2025). The distribution is characterized by conditional binomial distributions for \eqn{ X } and \eqn{ Y }.
}
\details{
The joint p.m.f. of the BBCD is
\deqn{
P(X = x, Y = y) = K_B(n_1, n_2, p_1, p_2, \lambda) \binom{n_1}{x} \binom{n_2}{y} p_1^x p_2^y (1 - p_1)^{n_1 - x} (1 - p_2)^{n_2 - y} \lambda^{xy},
}
where \eqn{ x = 0, 1, \ldots, n_1 }, \eqn{ y = 0, 1, \ldots, n_2 }, and \eqn{ K_B(n_1, n_2, p_1, p_2, \lambda) } is the normalizing constant.
}
\examples{
# Compute P(X = 2, Y = 1) with n1 = 5, n2 = 5, p1 = 0.5, p2 = 0.4, lambda = 0.5
dbinomBCD(x = 2, y = 1, n1 = 5, n2 = 5, p1 = 0.5, p2 = 0.4, lambda = 0.5)

# Example with independence (lambda = 1)
dbinomBCD(x = 2, y = 1, n1 = 5, n2 = 5, p1 = 0.5, p2 = 0.4, lambda = 1.0)

}
\references{
Ghosh, I., Marques, F., & Chakraborty, S. (2025). A form of bivariate binomial conditionals distributions. \emph{Communications in Statistics - Theory and Methods}, 54(2), 534--553. \doi{10.1080/03610926.2024.2315294}
}
\seealso{
\code{\link{pbinomBCD}} \code{\link{rbinomBCD}} \code{\link{MLEbinomBCD}}
}
