% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_scrape_shots_acb.R
\name{do_scrape_shots_acb}
\alias{do_scrape_shots_acb}
\title{ACB shooting data}
\usage{
do_scrape_shots_acb(data_days, verbose, user_agent_def, x_apikey)
}
\arguments{
\item{data_days}{Data frame with the game codes of each day. 
It is obtained with \code{\link{do_scrape_days_acb}}.}

\item{verbose}{Should R report information on progress? TRUE or FALSE.}

\item{user_agent_def}{String with the user agent.}

\item{x_apikey}{String with the X-APIKEY.}
}
\value{
A data frame with the shooting data.
}
\description{
Obtain the shooting data from the ACB website and creates a common R data structure.
Each shot is described with its (x, y) coordinates and other additional information, 
such as the outcome of the shot (made or missed) or the player who took that shot.
}
\note{
The original codes of the playType column have the following meaning:
92: ft made;    93: 2pt made;   94: 3pt made; 96: ft missed.
97: 2pt missed; 98: 3pt missed; 100: dunk.
}
\examples{
\dontrun{
data_days <- do_scrape_days_acb("2024", "analyst_name", TRUE, 2, 975)

data_shots <- do_scrape_shots_acb(data_days[1:2, ], TRUE, "user_agent_def", "x_apikey")
}

}
\seealso{
\code{\link{do_scrape_days_acb}}
}
\author{
Guillermo Vinue
}
