% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraping_rosters_euro.R
\name{scraping_rosters_euro}
\alias{scraping_rosters_euro}
\title{Euroleague and Eurocup players' profile}
\usage{
scraping_rosters_euro(competition, pcode, year, verbose = TRUE, 
                      r_user = "guillermo.vinue@uv.es")
}
\arguments{
\item{competition}{String. Options are "Euroleague" and "Eurocup".}

\item{pcode}{Code corresponding to the player's website to scrape.}

\item{year}{Year when the season starts. 2017 refers to 2017-2018 and so on.}

\item{verbose}{Should R report information on progress? Default TRUE.}

\item{r_user}{Email user to identify the user when doing web scraping. 
This is a polite way to do web scraping and to certify that the user 
is working as transparently as possible with a research purpose.}
}
\value{
Data frame with seven columns: 
\itemize{
\item CombinID: Unique ID to identify the players.
\item Player: Player's name.
\item Position: Player's position on the court.
\item Height: Player's height.
\item Date_birth: Player's birth date.
\item Nationality Player's nationality.
\item Website_player: Website.
}
}
\description{
This function allows us to obtain the basic information of each 
Euroleague/Eurocup player, including his birth date. Then, we will 
be able to compute the age that each player had in the date that he 
played each game. The websites used to collect information are
\url{www.euroleague.net} and \url{www.eurocupbasketball.com}.
}
\note{
In addition to use the email address to stay identifiable, the function also 
contains two headers regarding the R platform and version used.

Furthermore, in the robots.txt file located at
\url{http://www.euroleague.net/robots.txt} and 
\url{https://www.eurocupbasketball.com/robots.txt}
there is the Crawl-delay field which asks crawlers to pause between 
requests for 15 seconds. This is done by adding to the function the command
\code{Sys.sleep(15)}.
}
\examples{
\dontrun{
# Not needed to scrape every time the package is checked, built and installed.
# It takes 15 seconds as it is required in http://www.euroleague.net/robots.txt
df_bio <- scraping_rosters_euro("Euroleague", "005791", "2017", verbose = TRUE,
                                 r_user = "guillermo.vinue@uv.es")
}

}
\seealso{
\code{\link{do_scraping_rosters}}
}
\author{
Guillermo Vinue
}
