% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{coverage}
\alias{coverage}
\title{Coverage of datasets.}
\usage{
coverage(comm, tree)
}
\arguments{
\item{comm}{A matrix of sites x species with abundance values.}

\item{tree}{An hclust or phylo object (used only for PD or FD).}
}
\value{
A vector with coverage values per site.
}
\description{
Coverage is a measure of completeness of a dataset.
}
\details{
Calculated as the estimated proportion of individuals that belong to the species (or phylogenetic, or functional diversity) already collected (Chao and Jost 2012).
}
\examples{
comm <- matrix(c(2,1,0,0,100,1,2,0,0,3,1,2,4,0,0,0,0,0,2,2), nrow = 4, ncol = 5, byrow = TRUE)
tree <- hclust(dist(c(1:5), method="euclidean"), method="average")
coverage(comm)
coverage(comm, tree)
}
\references{
Chao, A. & Jost, L. (2012). Coverage-based rarefaction and extrapolation: standardizing samples by completeness rather than size. Ecology, 93: 2533-2547.
}
