% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{optim.beta.stats}
\alias{optim.beta.stats}
\title{Efficiency statistics for beta-sampling.}
\usage{
optim.beta.stats(comm, tree, methods, samples, abund = TRUE, runs = 1000)
}
\arguments{
\item{comm}{A samples x species x sites array, with either abundance or incidence data.}

\item{tree}{A phylo or hclust object (used only for PD or FD) or alternatively a species x traits matrix or data.frame to build a functional tree.}

\item{methods}{A data.frame with the method names (1st column) and number of samples per method (2nd column). The order of methods must be the same as in comm and the sum of the samples must be the same as nrow(comm).}

\item{samples}{A vector with the number of samples per method to test.}

\item{abund}{A boolean (T/F) indicating whether abundance data should be used (TRUE) or converted to incidence (FALSE) before analysis.}

\item{runs}{Number of random permutations to be made to the sample order. Default is 1000.}
}
\value{
A single precision value = (1 - average absolute beta diversity difference value).
}
\description{
Average absolute difference between sampled and real beta diversity when using a given number of samples per method.
}
\details{
Different combinations of samples per method allow sampling different sub-communities.
This function allows knowing the average absolute difference between sampled and real beta diversity for a given combination, for one or multiple sites simultaneously.
PD and FD are calculated based on a tree (hclust or phylo object, no need to be ultrametric).
}
\examples{
comm1 <- matrix(c(1,1,0,2,4,0,0,1,2,0,0,3), nrow = 4, ncol = 3, byrow = TRUE)
comm2 <- matrix(c(2,2,0,3,1,0,0,0,5,0,0,2), nrow = 4, ncol = 3, byrow = TRUE)
comm3 <- matrix(c(2,0,0,3,1,0,0,0,5,0,0,2), nrow = 4, ncol = 3, byrow = TRUE)
comm <- array(c(comm1, comm2, comm3), c(4,3,3))
colnames(comm) <- c("sp1","sp2","sp3")

tree <- tree.build(gower(1:3))
tree$tip.label <- colnames(comm)

methods <- data.frame(method = c("Met1","Met2","Met3"), nSamples = c(1,2,1))

optim.beta.stats(comm,,methods, c(1,2,1)) #a complete sample will have 0 difference
optim.beta.stats(comm, tree, methods = methods, samples = c(0,1,1), runs = 100)
}
