% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{raster.evenness}
\alias{raster.evenness}
\title{Maps of phylogenetic/functional evenness of species or individuals.}
\usage{
raster.evenness(layers, tree, distance, abund = TRUE)
}
\arguments{
\item{layers}{A Raster* object of species distributions (typically a multi-layer type: RasterStack or RasterBrick).}

\item{tree}{An hclust or phylo object representing a phylogenetic or functional tree. One of tree or distance must be provided.}

\item{distance}{A dist object representing the phylogenetic or functional distance between species.}

\item{abund}{A boolean (T/F) indicating whether evenness should be calculated using abundance data.}
}
\value{
A raster object representing evenness in space.
}
\description{
Regularity of distance and abundance between any two species in a community using rasters of species distributions (presence/absence or abundance).
}
\details{
Evenness is calculated based on the index of Bulla (1994) using the values of both edge lengths in the tree and their abundance.

If no tree or distance is provided the result is the original index of Bulla with correction.
}
\examples{
sp1 <- raster::raster(matrix(c(NA,1,1,1,1,0,0,0,0), nrow = 3, ncol = 3, byrow = TRUE))
sp2 <- raster::raster(matrix(c(0,0,0,0,1,1,1,1,1), nrow = 3, ncol = 3, byrow = TRUE))
sp3 <- raster::raster(matrix(c(0,0,0,1,1,1,0,0,0), nrow = 3, ncol = 3, byrow = TRUE))
spp <- raster::stack(sp1, sp2, sp3)
tree <- hclust(dist(c(1:3), method="euclidean"), method="average")
raster.evenness(spp, tree)
}
\references{
Bulla, L. (1994) An index of evenness and its associated diversity measure. Oikos, 70: 167-171.
}
