% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{kernel.contribution}
\alias{kernel.contribution}
\title{Contribution of species or individuals to total kernel density hypervolume.}
\usage{
kernel.contribution(comm, trait, method = "box", abund = FALSE)
}
\arguments{
\item{comm}{An hypervolume object constructed with the hypervolume R package. Alternatively, a sites x species matrix, with incidence or abundance data about the species in the community. Note that HypervolumeList is not implemented for this function yet.}

\item{trait}{A matrix of traits for each species in comm (a species for each row and traits as columns). Must be provided only if 'comm' is a sites x species matrix.}

\item{method}{Method for constructing the hypervolume. One of "box" (box kernel density estimation), "gaussian" (Gaussian kernel density estimation), or "svm" (one-class support vector machine). See respective functions of the hypervolume package for details. Must be provided only if 'comm' is a sites x species matrix.}

\item{abund}{A boolean (T/F) indicating whether abundance data should be used or converted to incidence before analysis. If not specified, default is FALSE. Ignored if a Hypervolume is provided as input data.}
}
\value{
A matrix with the contribution values of each species or individual for each site.
}
\description{
Contribution of each species or individual to the total volume of one or more kernel hypervolumes.
}
\details{
The contribution of each observation (species or individual) to the total volume of a kernel hypervolume is calculated as the difference in volume between the total hypervolume 
and a second hypervolume lacking this specific observation (i.e., leave-one-out). For large sample sizes, computation time can be high.
Note that the contribution of a species or individual can be negative, if the removal of an observation increases the total volume.
}
\examples{
comm <- rbind(c(0,3,2,1), c(1,5,6,2), c(0,0,2,1))
rownames(comm) = c("Community_1", "Community_2", "Community_3")
colnames(comm) = c("Sp_1", "Sp_2", "Sp_3", "Sp_4")

trait <- cbind(c(2.2,4.4,6.1,8.3), c(0.5,1,0.5,0.4), c(0.7,1.2,0.5,0.4))
rownames(trait) = c("Sp_1", "Sp_2", "Sp_3", "Sp_4")
colnames(trait) = c("Trait_1", "Trait_2", "Trait_3")

#Example with community and trait matrices as input data
#kernel.contribution(comm = comm, trait = trait, method = "box")

#Example with hypervolume as input data
#kernel.contribution(hypervolume_box(trait))
}
\references{
Mammola, S. & Cardoso, P. (Submitted). New functions for calculating functional diversity metrics using kernel density n-dimensional hypervolumes.
}
