% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/BAT.R
\name{beta.accum}
\alias{beta.accum}
\title{Beta diversity accumulation curves.}
\usage{
beta.accum(comm1, comm2, tree, abund = FALSE, func = "jaccard",
  runs = 100)
}
\arguments{
\item{comm1}{A sampling units x species matrix for the first site, with either abundance or incidence data.}

\item{comm2}{A sampling units x species matrix for the second site, with either abundance or incidence data.}

\item{tree}{An hclust or phylo object (used only for Phylogenetic (PD) or Functional (FD) Diversity, not for Taxon Diversity (TD)).}

\item{abund}{A boolean (T/F) indicating whether abundance data should be used or converted to incidence before analysis. If not specified, default is FALSE.}

\item{func}{Partial match indicating whether the Jaccard or Soerensen family of beta diversity measures should be used. If not specified, default is jaccard.}

\item{runs}{Number of random permutations to be made to the sampling order. If not specified, default is 100.}
}
\value{
Three matrices of sampling units x diversity values, one per each of the three beta diversity measures (sampling units, individuals and observed diversity).
}
\description{
Beta diversity between two sites with accumulation of sampling units.
}
\details{
As widely recognized for species richness, beta diversity is also biased when communities are undersampled.
Beta diversity accumulation curves have been proposed by Cardoso et al. (2009) to test if beta diversity has approached an asymptote when comparing two undersampled sites.
The beta diversity measures used here follow the partitioning framework independently developed by Podani & Schmera (2011) and Carvalho et al. (2012)
and later expanded to PD and FD by Cardoso et al. (2014), where Btotal = Brepl + Brich.
Btotal = total beta diversity, reflecting both species replacement and loss/gain;
Brepl = beta diversity explained by replacement of species alone;
Brich = beta diversity explained by species loss/gain (richness differences) alone.
PD and FD are calculated based on an ultrametric tree (hclust or phylo object). The path to the root of the tree is always included in calculations of PD and FD.
The number and order of species in comm1 and comm2 must be the same as in tree. Also, the number of sampling units should be similar in both sites.
}
\examples{
comm1 <- matrix(c(2,2,0,0,0,1,1,0,0,0,0,2,2,0,0,0,0,0,2,2), nrow = 4, byrow = TRUE)
comm2 <- matrix(c(1,1,0,0,0,0,2,1,0,0,0,0,2,1,0,0,0,0,2,1), nrow = 4, byrow = TRUE)
tree <- hclust(dist(c(1:5), method="euclidean"), method="average")
beta.accum(comm1, comm2)
beta.accum(comm1, comm2, func = "Soerensen")
beta.accum(comm1, comm2, tree)
beta.accum(comm1, comm2, abund = TRUE)
beta.accum(comm1, comm2, tree, FALSE)
}
\references{
Cardoso, P., Borges, P.A.V. & Veech, J.A. (2009) Testing the performance of beta diversity measures based on incidence data: the robustness to undersampling. Diversity and Distributions, 15, 1081-1090.

Cardoso, P., Rigal, F., Carvalho, J.C., Fortelius, M., Borges, P.A.V., Podani, J. & Schmera, D. (2014) Partitioning taxon, phylogenetic and functional beta diversity into replacement and richness difference components. Journal of Biogeography, 41, 749-761.

Carvalho, J.C., Cardoso, P. & Gomes, P. (2012) Determining the relative roles of species replacement and species richness differences in generating beta-diversity patterns. Global Ecology and Biogeography, 21, 760-771.

Podani, J. & Schmera, D. (2011) A new conceptual and methodological framework for exploring and explaining pattern in presence-absence data. Oikos, 120, 1625-1638.
}

